/*
 * Decompiled with CFR 0.152.
 */
package dev.snowdrop.boot.narayana.openshift.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import dev.snowdrop.boot.narayana.openshift.recovery.PodStatus;
import dev.snowdrop.boot.narayana.openshift.recovery.PodStatusManager;
import dev.snowdrop.boot.narayana.openshift.recovery.RecoveryErrorDetector;
import dev.snowdrop.boot.narayana.openshift.recovery.ServiceShutdownController;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarayanaRecoveryTerminationController {
    private static final Logger LOG = LoggerFactory.getLogger(NarayanaRecoveryTerminationController.class);
    private PodStatusManager podStatusManager;
    private List<ServiceShutdownController> shutdownHooks;
    private List<RecoveryErrorDetector> recoveryErrorDetectors;

    public NarayanaRecoveryTerminationController(PodStatusManager podStatusManager, List<ServiceShutdownController> shutdownControllers, List<RecoveryErrorDetector> recoveryErrorDetectors) {
        this.podStatusManager = Objects.requireNonNull(podStatusManager, "podStatusManager cannot be null");
        this.shutdownHooks = Objects.requireNonNull(shutdownControllers, "shutdownControllers cannot be null");
        this.recoveryErrorDetectors = Objects.requireNonNull(recoveryErrorDetectors, "recoveryErrorDetectors cannot be null");
    }

    public void start() {
        LOG.info("Narayana recovery termination controller started");
        this.podStatusManager.setStatus(PodStatus.RUNNING);
    }

    public void stop() {
        try {
            this.waitForShutdownControllersToStop();
            this.startRecoveryErrorDetectors();
            LOG.info("Performing transaction recovery scan...");
            RecoveryManager.manager().scan();
            LOG.info("Performing second run of transaction recovery scan...");
            RecoveryManager.manager().scan();
        }
        catch (Exception ex) {
            LOG.error("Error while performing transaction scan", (Throwable)ex);
        }
        finally {
            this.stopRecoveryErrorDetectors();
        }
        if (this.recoveryErrorsDetected()) {
            LOG.error("Errors detected while performing the recovery manager scan. Scan result is invalid.");
            this.podStatusManager.setStatus(PodStatus.PENDING);
        } else {
            try {
                List<Uid> pendingUids = this.getPendingUids();
                if (pendingUids.isEmpty()) {
                    LOG.info("There are no pending transactions left");
                    this.podStatusManager.setStatus(PodStatus.STOPPED);
                } else {
                    LOG.warn("There are pending transactions: {}", pendingUids);
                    this.podStatusManager.setStatus(PodStatus.PENDING);
                }
            }
            catch (Exception ex) {
                LOG.error("Error while trying to detect pending transactions", (Throwable)ex);
            }
        }
    }

    private void waitForShutdownControllersToStop() throws InterruptedException {
        for (ServiceShutdownController hook : this.shutdownHooks) {
            hook.stop();
        }
        LOG.info("All service shutdown hooks stopped");
    }

    private List<Uid> getPendingUids() throws Exception {
        InputObjectState types = new InputObjectState();
        StoreManager.getRecoveryStore().allTypes(types);
        ArrayList<Uid> allUIDs = new ArrayList<Uid>();
        String typeName = types.unpackString();
        while (typeName != null && typeName.compareTo("") != 0) {
            List<Uid> uids = this.getPendingUids(typeName);
            if (uids.isEmpty()) {
                LOG.debug("Found {} UIDs for action type {}", (Object)0, (Object)typeName);
            } else {
                LOG.warn("Found {} UIDs for action type {}", (Object)uids.size(), (Object)typeName);
            }
            allUIDs.addAll(uids);
            typeName = types.unpackString();
        }
        return allUIDs;
    }

    private List<Uid> getPendingUids(String type) throws Exception {
        ArrayList<Uid> uidList = new ArrayList<Uid>();
        InputObjectState uids = new InputObjectState();
        if (!StoreManager.getRecoveryStore().allObjUids(type, uids)) {
            throw new RuntimeException("Cannot obtain pending Uids");
        }
        if (uids.notempty()) {
            Uid u;
            do {
                u = UidHelper.unpackFrom((InputBuffer)uids);
                if (!Uid.nullUid().notEquals(u)) continue;
                uidList.add(u);
            } while (Uid.nullUid().notEquals(u));
        }
        return uidList;
    }

    private void startRecoveryErrorDetectors() {
        for (RecoveryErrorDetector recoveryErrorDetector : this.recoveryErrorDetectors) {
            recoveryErrorDetector.startDetection();
        }
    }

    private void stopRecoveryErrorDetectors() {
        for (RecoveryErrorDetector recoveryErrorDetector : this.recoveryErrorDetectors) {
            recoveryErrorDetector.stopDetection();
        }
    }

    private boolean recoveryErrorsDetected() {
        for (RecoveryErrorDetector recoveryErrorDetector : this.recoveryErrorDetectors) {
            if (!recoveryErrorDetector.errorsDetected()) continue;
            return true;
        }
        return false;
    }
}

