/*
 * Decompiled with CFR 0.152.
 */
package dev.snipme.highlights;

import dev.snipme.highlights.internal.CodeAnalyzer;
import dev.snipme.highlights.internal.CodeSnapshot;
import dev.snipme.highlights.model.BoldHighlight;
import dev.snipme.highlights.model.CodeHighlight;
import dev.snipme.highlights.model.CodeStructure;
import dev.snipme.highlights.model.ColorHighlight;
import dev.snipme.highlights.model.PhraseLocation;
import dev.snipme.highlights.model.SyntaxLanguage;
import dev.snipme.highlights.model.SyntaxTheme;
import dev.snipme.highlights.model.SyntaxThemes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0002!\"B-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\tJ\u0006\u0010\u0019\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003J\u001f\u0010\u001d\u001a\u00020\u001c2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u001f\"\u00020\n\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Ldev/snipme/highlights/Highlights;", "", "code", "", "language", "Ldev/snipme/highlights/model/SyntaxLanguage;", "theme", "Ldev/snipme/highlights/model/SyntaxTheme;", "emphasisLocations", "", "Ldev/snipme/highlights/model/PhraseLocation;", "(Ljava/lang/String;Ldev/snipme/highlights/model/SyntaxLanguage;Ldev/snipme/highlights/model/SyntaxTheme;Ljava/util/List;)V", "<set-?>", "Ldev/snipme/highlights/internal/CodeSnapshot;", "snapshot", "getSnapshot", "()Ldev/snipme/highlights/internal/CodeSnapshot;", "getBuilder", "Ldev/snipme/highlights/Highlights$Builder;", "getCode", "getCodeStructure", "Ldev/snipme/highlights/model/CodeStructure;", "getEmphasis", "getHighlights", "Ldev/snipme/highlights/model/CodeHighlight;", "getLanguage", "getTheme", "setCode", "", "setEmphasis", "locations", "", "([Ldev/snipme/highlights/model/PhraseLocation;)V", "Builder", "Companion", "highlights"})
@SourceDebugExtension(value={"SMAP\nHighlights.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Highlights.kt\ndev/snipme/highlights/Highlights\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1855#2,2:92\n1855#2,2:94\n1855#2,2:96\n1855#2,2:98\n1855#2,2:100\n1855#2,2:102\n1855#2,2:104\n1855#2,2:106\n1855#2,2:108\n*S KotlinDebug\n*F\n+ 1 Highlights.kt\ndev/snipme/highlights/Highlights\n*L\n66#1:92,2\n67#1:94,2\n68#1:96,2\n69#1:98,2\n70#1:100,2\n71#1:102,2\n72#1:104,2\n73#1:106,2\n76#1:108,2\n*E\n"})
public final class Highlights {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String code;
    @NotNull
    private final SyntaxLanguage language;
    @NotNull
    private final SyntaxTheme theme;
    @NotNull
    private List<PhraseLocation> emphasisLocations;
    @Nullable
    private CodeSnapshot snapshot;

    private Highlights(String code, SyntaxLanguage language, SyntaxTheme theme, List<PhraseLocation> emphasisLocations) {
        this.code = code;
        this.language = language;
        this.theme = theme;
        this.emphasisLocations = emphasisLocations;
    }

    @Nullable
    public final CodeSnapshot getSnapshot() {
        return this.snapshot;
    }

    public final void setCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.code = code;
    }

    public final void setEmphasis(PhraseLocation ... locations) {
        Intrinsics.checkNotNullParameter((Object)locations, (String)"locations");
        this.emphasisLocations = ArraysKt.toList((Object[])locations);
    }

    @NotNull
    public final CodeStructure getCodeStructure() {
        CodeStructure structure = CodeAnalyzer.INSTANCE.analyze(this.code, this.language, this.snapshot);
        this.snapshot = new CodeSnapshot(this.code, structure, this.language);
        return structure;
    }

    @NotNull
    public final List<CodeHighlight> getHighlights() {
        PhraseLocation it;
        CodeStructure structure;
        List highlights = new ArrayList();
        CodeStructure $this$getHighlights_u24lambda_u248 = structure = this.getCodeStructure();
        boolean bl = false;
        Iterable $this$forEach$iv = $this$getHighlights_u24lambda_u248.getMarks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PhraseLocation)element$iv;
            boolean bl2 = false;
            highlights.add(new ColorHighlight(it, this.theme.getMark()));
        }
        $this$forEach$iv = $this$getHighlights_u24lambda_u248.getPunctuations();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PhraseLocation)element$iv;
            boolean bl3 = false;
            highlights.add(new ColorHighlight(it, this.theme.getPunctuation()));
        }
        $this$forEach$iv = $this$getHighlights_u24lambda_u248.getKeywords();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PhraseLocation)element$iv;
            boolean bl4 = false;
            highlights.add(new ColorHighlight(it, this.theme.getKeyword()));
        }
        $this$forEach$iv = $this$getHighlights_u24lambda_u248.getStrings();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PhraseLocation)element$iv;
            boolean bl5 = false;
            highlights.add(new ColorHighlight(it, this.theme.getString()));
        }
        $this$forEach$iv = $this$getHighlights_u24lambda_u248.getLiterals();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PhraseLocation)element$iv;
            boolean bl6 = false;
            highlights.add(new ColorHighlight(it, this.theme.getLiteral()));
        }
        $this$forEach$iv = $this$getHighlights_u24lambda_u248.getAnnotations();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PhraseLocation)element$iv;
            boolean bl7 = false;
            highlights.add(new ColorHighlight(it, this.theme.getMetadata()));
        }
        $this$forEach$iv = $this$getHighlights_u24lambda_u248.getComments();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PhraseLocation)element$iv;
            boolean bl8 = false;
            highlights.add(new ColorHighlight(it, this.theme.getComment()));
        }
        $this$forEach$iv = $this$getHighlights_u24lambda_u248.getMultilineComments();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PhraseLocation)element$iv;
            boolean bl9 = false;
            highlights.add(new ColorHighlight(it, this.theme.getMultilineComment()));
        }
        Iterable $this$forEach$iv2 = this.emphasisLocations;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            PhraseLocation it2 = (PhraseLocation)element$iv;
            boolean bl10 = false;
            highlights.add(new BoldHighlight(it2));
        }
        return highlights;
    }

    @NotNull
    public final Builder getBuilder() {
        return new Builder(this.code, this.language, this.theme, this.emphasisLocations);
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    @NotNull
    public final SyntaxLanguage getLanguage() {
        return this.language;
    }

    @NotNull
    public final SyntaxTheme getTheme() {
        return this.theme;
    }

    @NotNull
    public final List<PhraseLocation> getEmphasis() {
        return this.emphasisLocations;
    }

    public /* synthetic */ Highlights(String code, SyntaxLanguage language, SyntaxTheme theme, List emphasisLocations, DefaultConstructorMarker $constructor_marker) {
        this(code, language, theme, emphasisLocations);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u001f\u0010#\u001a\u00020\u00002\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0%\"\u00020\n\u00a2\u0006\u0002\u0010&J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Ldev/snipme/highlights/Highlights$Builder;", "", "code", "", "language", "Ldev/snipme/highlights/model/SyntaxLanguage;", "theme", "Ldev/snipme/highlights/model/SyntaxTheme;", "emphasisLocations", "", "Ldev/snipme/highlights/model/PhraseLocation;", "(Ljava/lang/String;Ldev/snipme/highlights/model/SyntaxLanguage;Ldev/snipme/highlights/model/SyntaxTheme;Ljava/util/List;)V", "getCode", "()Ljava/lang/String;", "setCode", "(Ljava/lang/String;)V", "getEmphasisLocations", "()Ljava/util/List;", "setEmphasisLocations", "(Ljava/util/List;)V", "getLanguage", "()Ldev/snipme/highlights/model/SyntaxLanguage;", "setLanguage", "(Ldev/snipme/highlights/model/SyntaxLanguage;)V", "getTheme", "()Ldev/snipme/highlights/model/SyntaxTheme;", "setTheme", "(Ldev/snipme/highlights/model/SyntaxTheme;)V", "build", "Ldev/snipme/highlights/Highlights;", "component1", "component2", "component3", "component4", "copy", "emphasis", "locations", "", "([Ldev/snipme/highlights/model/PhraseLocation;)Ldev/snipme/highlights/Highlights$Builder;", "equals", "", "other", "hashCode", "", "toString", "highlights"})
    @SourceDebugExtension(value={"SMAP\nHighlights.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Highlights.kt\ndev/snipme/highlights/Highlights$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
    public static final class Builder {
        @NotNull
        private String code;
        @NotNull
        private SyntaxLanguage language;
        @NotNull
        private SyntaxTheme theme;
        @NotNull
        private List<PhraseLocation> emphasisLocations;

        public Builder(@NotNull String code, @NotNull SyntaxLanguage language, @NotNull SyntaxTheme theme, @NotNull List<PhraseLocation> emphasisLocations) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Intrinsics.checkNotNullParameter(emphasisLocations, (String)"emphasisLocations");
            this.code = code;
            this.language = language;
            this.theme = theme;
            this.emphasisLocations = emphasisLocations;
        }

        public /* synthetic */ Builder(String string, SyntaxLanguage syntaxLanguage, SyntaxTheme syntaxTheme, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                syntaxLanguage = SyntaxLanguage.DEFAULT;
            }
            if ((n & 4) != 0) {
                syntaxTheme = SyntaxThemes.default$default(SyntaxThemes.INSTANCE, false, 1, null);
            }
            if ((n & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string, syntaxLanguage, syntaxTheme, list);
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        public final void setCode(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.code = string;
        }

        @NotNull
        public final SyntaxLanguage getLanguage() {
            return this.language;
        }

        public final void setLanguage(@NotNull SyntaxLanguage syntaxLanguage) {
            Intrinsics.checkNotNullParameter((Object)((Object)syntaxLanguage), (String)"<set-?>");
            this.language = syntaxLanguage;
        }

        @NotNull
        public final SyntaxTheme getTheme() {
            return this.theme;
        }

        public final void setTheme(@NotNull SyntaxTheme syntaxTheme) {
            Intrinsics.checkNotNullParameter((Object)syntaxTheme, (String)"<set-?>");
            this.theme = syntaxTheme;
        }

        @NotNull
        public final List<PhraseLocation> getEmphasisLocations() {
            return this.emphasisLocations;
        }

        public final void setEmphasisLocations(@NotNull List<PhraseLocation> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.emphasisLocations = list;
        }

        @NotNull
        public final Builder code(@NotNull String code) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Builder $this$code_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$code_u24lambda_u240.code = code;
            return builder;
        }

        @NotNull
        public final Builder language(@NotNull SyntaxLanguage language) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            Builder $this$language_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$language_u24lambda_u241.language = language;
            return builder;
        }

        @NotNull
        public final Builder theme(@NotNull SyntaxTheme theme) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Builder $this$theme_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$theme_u24lambda_u242.theme = theme;
            return builder;
        }

        @NotNull
        public final Builder emphasis(PhraseLocation ... locations) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)locations, (String)"locations");
            Builder $this$emphasis_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$emphasis_u24lambda_u243.emphasisLocations = ArraysKt.toList((Object[])locations);
            return builder;
        }

        @NotNull
        public final Highlights build() {
            return new Highlights(this.code, this.language, this.theme, this.emphasisLocations, null);
        }

        @NotNull
        public final String component1() {
            return this.code;
        }

        @NotNull
        public final SyntaxLanguage component2() {
            return this.language;
        }

        @NotNull
        public final SyntaxTheme component3() {
            return this.theme;
        }

        @NotNull
        public final List<PhraseLocation> component4() {
            return this.emphasisLocations;
        }

        @NotNull
        public final Builder copy(@NotNull String code, @NotNull SyntaxLanguage language, @NotNull SyntaxTheme theme, @NotNull List<PhraseLocation> emphasisLocations) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Intrinsics.checkNotNullParameter(emphasisLocations, (String)"emphasisLocations");
            return new Builder(code, language, theme, emphasisLocations);
        }

        public static /* synthetic */ Builder copy$default(Builder builder, String string, SyntaxLanguage syntaxLanguage, SyntaxTheme syntaxTheme, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = builder.code;
            }
            if ((n & 2) != 0) {
                syntaxLanguage = builder.language;
            }
            if ((n & 4) != 0) {
                syntaxTheme = builder.theme;
            }
            if ((n & 8) != 0) {
                list = builder.emphasisLocations;
            }
            return builder.copy(string, syntaxLanguage, syntaxTheme, list);
        }

        @NotNull
        public String toString() {
            return "Builder(code=" + this.code + ", language=" + (Object)((Object)this.language) + ", theme=" + this.theme + ", emphasisLocations=" + this.emphasisLocations + ')';
        }

        public int hashCode() {
            int result = this.code.hashCode();
            result = result * 31 + this.language.hashCode();
            result = result * 31 + this.theme.hashCode();
            result = result * 31 + ((Object)this.emphasisLocations).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Builder)) {
                return false;
            }
            Builder builder = (Builder)other;
            if (!Intrinsics.areEqual((Object)this.code, (Object)builder.code)) {
                return false;
            }
            if (this.language != builder.language) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.theme, (Object)builder.theme)) {
                return false;
            }
            return Intrinsics.areEqual(this.emphasisLocations, builder.emphasisLocations);
        }

        public Builder() {
            this(null, null, null, null, 15, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Ldev/snipme/highlights/Highlights$Companion;", "", "()V", "default", "Ldev/snipme/highlights/Highlights;", "fromBuilder", "builder", "Ldev/snipme/highlights/Highlights$Builder;", "languages", "", "Ldev/snipme/highlights/model/SyntaxLanguage;", "themes", "", "", "Ldev/snipme/highlights/model/SyntaxTheme;", "darkMode", "", "highlights"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Highlights default() {
            return this.fromBuilder(new Builder(null, null, null, null, 15, null));
        }

        @NotNull
        public final Highlights fromBuilder(@NotNull Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            return builder.build();
        }

        @NotNull
        public final Map<String, SyntaxTheme> themes(boolean darkMode) {
            return SyntaxThemes.INSTANCE.themes(darkMode);
        }

        @NotNull
        public final List<SyntaxLanguage> languages() {
            return ArraysKt.toList((Object[])SyntaxLanguage.values());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

