/*
 * Decompiled with CFR 0.152.
 */
package dev.snipme.highlights.internal;

import dev.snipme.highlights.internal.CodeComparator;
import dev.snipme.highlights.internal.CodeDifference;
import dev.snipme.highlights.internal.CodeSnapshot;
import dev.snipme.highlights.internal.SyntaxTokens;
import dev.snipme.highlights.internal.locator.AnnotationLocator;
import dev.snipme.highlights.internal.locator.CommentLocator;
import dev.snipme.highlights.internal.locator.KeywordLocator;
import dev.snipme.highlights.internal.locator.MarkLocator;
import dev.snipme.highlights.internal.locator.MultilineCommentLocator;
import dev.snipme.highlights.internal.locator.NumericLiteralLocator;
import dev.snipme.highlights.internal.locator.PunctuationLocator;
import dev.snipme.highlights.internal.locator.StringLocator;
import dev.snipme.highlights.model.CodeStructure;
import dev.snipme.highlights.model.SyntaxLanguage;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Ldev/snipme/highlights/internal/CodeAnalyzer;", "", "()V", "analyze", "Ldev/snipme/highlights/model/CodeStructure;", "code", "", "language", "Ldev/snipme/highlights/model/SyntaxLanguage;", "snapshot", "Ldev/snipme/highlights/internal/CodeSnapshot;", "analyzeCodeWithKeywords", "keywords", "", "analyzeForLanguage", "analyzeFull", "analyzePartial", "codeSnapshot", "highlights"})
public final class CodeAnalyzer {
    @NotNull
    public static final CodeAnalyzer INSTANCE = new CodeAnalyzer();

    private CodeAnalyzer() {
    }

    @NotNull
    public final CodeStructure analyze(@NotNull String code, @NotNull SyntaxLanguage language, @Nullable CodeSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        return snapshot == null ? this.analyzeFull(code, language) : (language != snapshot.getLanguage() ? this.analyzeFull(code, language) : (!Intrinsics.areEqual((Object)code, (Object)snapshot.getCode()) ? this.analyzePartial(snapshot, code) : snapshot.getStructure()));
    }

    public static /* synthetic */ CodeStructure analyze$default(CodeAnalyzer codeAnalyzer, String string, SyntaxLanguage syntaxLanguage, CodeSnapshot codeSnapshot, int n, Object object) {
        if ((n & 2) != 0) {
            syntaxLanguage = SyntaxLanguage.DEFAULT;
        }
        if ((n & 4) != 0) {
            codeSnapshot = null;
        }
        return codeAnalyzer.analyze(string, syntaxLanguage, codeSnapshot);
    }

    private final CodeStructure analyzeFull(String code, SyntaxLanguage language) {
        return this.analyzeForLanguage(code, language);
    }

    private final CodeStructure analyzePartial(CodeSnapshot codeSnapshot, String code) {
        CodeStructure codeStructure;
        CodeStructure newStructure;
        CodeDifference difference = CodeComparator.INSTANCE.difference(codeSnapshot.getCode(), code);
        CodeDifference codeDifference = difference;
        if (codeDifference instanceof CodeDifference.Increase) {
            newStructure = this.analyzeForLanguage(((CodeDifference.Increase)difference).getChange(), codeSnapshot.getLanguage());
            codeStructure = codeSnapshot.getStructure().plus(newStructure.move(codeSnapshot.getCode().length() + 1));
        } else if (codeDifference instanceof CodeDifference.Decrease) {
            newStructure = this.analyzeForLanguage(((CodeDifference.Decrease)difference).getChange(), codeSnapshot.getLanguage());
            int lengthDifference = codeSnapshot.getCode().length() - ((CodeDifference.Decrease)difference).getChange().length();
            codeStructure = codeSnapshot.getStructure().minus(newStructure.move(lengthDifference));
        } else {
            if (Intrinsics.areEqual((Object)codeDifference, (Object)CodeDifference.None.INSTANCE)) {
                return codeSnapshot.getStructure();
            }
            throw new NoWhenBranchMatchedException();
        }
        CodeStructure structure = codeStructure;
        return structure;
    }

    private final CodeStructure analyzeForLanguage(String code, SyntaxLanguage language) {
        CodeStructure codeStructure;
        switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
            case 1: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getALL_KEYWORDS());
                break;
            }
            case 2: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getALL_MIXED_KEYWORDS());
                break;
            }
            case 3: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getC_KEYWORDS());
                break;
            }
            case 4: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getCPP_KEYWORDS());
                break;
            }
            case 5: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getJAVA_KEYWORDS());
                break;
            }
            case 6: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getKOTLIN_KEYWORDS());
                break;
            }
            case 7: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getRUST_KEYWORDS());
                break;
            }
            case 8: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getCSHARP_KEYWORDS());
                break;
            }
            case 9: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getCOFFEE_KEYWORDS());
                break;
            }
            case 10: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getJSCRIPT_KEYWORDS());
                break;
            }
            case 11: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getPERL_KEYWORDS());
                break;
            }
            case 12: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getPYTHON_KEYWORDS());
                break;
            }
            case 13: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getRUBY_KEYWORDS());
                break;
            }
            case 14: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getSH_KEYWORDS());
                break;
            }
            case 15: {
                codeStructure = this.analyzeCodeWithKeywords(code, SyntaxTokens.INSTANCE.getSWIFT_KEYWORDS());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return codeStructure;
    }

    private final CodeStructure analyzeCodeWithKeywords(String code, List<String> keywords) {
        return new CodeStructure(MarkLocator.INSTANCE.locate(code), PunctuationLocator.INSTANCE.locate(code), KeywordLocator.INSTANCE.locate(code, keywords), StringLocator.INSTANCE.locate(code), NumericLiteralLocator.INSTANCE.locate(code), CommentLocator.INSTANCE.locate(code), MultilineCommentLocator.INSTANCE.locate(code), AnnotationLocator.INSTANCE.locate(code), false);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SyntaxLanguage.values().length];
            try {
                nArray[SyntaxLanguage.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.MIXED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.C.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.CPP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.JAVA.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.KOTLIN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.RUST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.CSHARP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.COFFEESCRIPT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.JAVASCRIPT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.PERL.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.PYTHON.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.RUBY.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.SHELL.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SyntaxLanguage.SWIFT.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

