/*
 * Decompiled with CFR 0.152.
 */
package dev.snipme.highlights.internal.locator;

import dev.snipme.highlights.internal.ExtensionsKt;
import dev.snipme.highlights.internal.SyntaxTokens;
import dev.snipme.highlights.internal.locator.NumericLiteralLocator;
import dev.snipme.highlights.internal.locator.NumericLiteralLocatorKt;
import dev.snipme.highlights.model.PhraseLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J$\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0006J\u001c\u0010\u0011\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0014\u0010\u0013\u001a\u00020\u000f*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0004H\u0002\u00a8\u0006\u0015"}, d2={"Ldev/snipme/highlights/internal/locator/NumericLiteralLocator;", "", "()V", "calculateNumberLength", "", "number", "", "findDigitIndices", "", "Ldev/snipme/highlights/model/PhraseLocation;", "code", "getLengthOfSubstringFor", "condition", "Lkotlin/Function1;", "", "", "locate", "isFullNumber", "startIndex", "isNumberFirstIndex", "index", "highlights"})
@SourceDebugExtension(value={"SMAP\nNumericLiteralLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumericLiteralLocator.kt\ndev/snipme/highlights/internal/locator/NumericLiteralLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,105:1\n819#2:106\n847#2,2:107\n1855#2,2:112\n1747#2,3:121\n37#3,2:109\n1295#4:111\n1296#4:114\n429#5:115\n502#5,5:116\n1099#5,3:124\n1099#5,3:127\n1174#5,2:130\n*S KotlinDebug\n*F\n+ 1 NumericLiteralLocator.kt\ndev/snipme/highlights/internal/locator/NumericLiteralLocator\n*L\n22#1:106\n22#1:107,2\n34#1:112,2\n82#1:121,3\n22#1:109,2\n32#1:111\n32#1:114\n68#1:115\n68#1:116,5\n83#1:124,3\n84#1:127,3\n94#1:130,2\n*E\n"})
public final class NumericLiteralLocator {
    @NotNull
    public static final NumericLiteralLocator INSTANCE = new NumericLiteralLocator();

    private NumericLiteralLocator() {
    }

    @NotNull
    public final List<PhraseLocation> locate(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return this.findDigitIndices(code);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PhraseLocation> findDigitIndices(String code) {
        void $this$forEach$iv;
        Sequence $this$toTypedArray$iv;
        void $this$filterNotTo$iv$iv;
        Set foundPhrases = new LinkedHashSet();
        Set locations = new LinkedHashSet();
        Iterable $this$filterNot$iv = SyntaxTokens.INSTANCE.getTOKEN_DELIMITERS();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)".")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] delimiters = thisCollection$iv.toArray(new String[0]);
        $this$toTypedArray$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)code, (String[])Arrays.copyOf(delimiters, delimiters.length), (boolean)false, (int)0, (int)6, null)), (Function1)((Function1)new Function1<String, Boolean>((Set<String>)foundPhrases){
            final /* synthetic */ Set<String> $foundPhrases;
            {
                this.$foundPhrases = $foundPhrases;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$foundPhrases.contains(it);
            }
        })), (Function1)findDigitIndices.2.INSTANCE), (Function1)findDigitIndices.3.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String number = (String)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = ExtensionsKt.indicesOf(code, number);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                int startIndex = ((Number)element$iv2).intValue();
                boolean bl2 = false;
                if (!INSTANCE.isFullNumber(code, number, startIndex) || !INSTANCE.isNumberFirstIndex(code, startIndex)) continue;
                int length = INSTANCE.calculateNumberLength(number);
                locations.add(new PhraseLocation(startIndex, startIndex + length));
            }
            foundPhrases.add(number);
        }
        return CollectionsKt.toList((Iterable)locations);
    }

    private final boolean isNumberFirstIndex(String $this$isNumberFirstIndex, int index) {
        if (index < 0) {
            return false;
        }
        if (index == 0) {
            return true;
        }
        int positionBefore = Math.max(index - 1, 0);
        Character c = StringsKt.getOrNull((CharSequence)$this$isNumberFirstIndex, (int)positionBefore);
        if (c == null) {
            return false;
        }
        char charBefore = c.charValue();
        return SyntaxTokens.INSTANCE.getTOKEN_DELIMITERS().contains(String.valueOf(charBefore));
    }

    private final boolean isFullNumber(String $this$isFullNumber, String number, int startIndex) {
        int numberEndingIndex = startIndex + number.length();
        if (numberEndingIndex >= StringsKt.getLastIndex((CharSequence)$this$isFullNumber)) {
            return true;
        }
        Character c = StringsKt.getOrNull((CharSequence)$this$isFullNumber, (int)numberEndingIndex);
        if (c == null) {
            return false;
        }
        char numberEnding = c.charValue();
        return SyntaxTokens.INSTANCE.getTOKEN_DELIMITERS().contains(String.valueOf(numberEnding));
    }

    private final int calculateNumberLength(String number) {
        boolean bl;
        block9: {
            Iterator $this$filterTo$iv$iv;
            String $this$filter$iv = number;
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                if (!Character.isLetter(it)) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
            String letters = string;
            if (StringsKt.startsWith$default((String)number, (String)"0x", (boolean)false, (int)2, null)) {
                return this.getLengthOfSubstringFor(number, (Function1<? super Character, Boolean>)((Function1)calculateNumberLength.1.INSTANCE));
            }
            if (StringsKt.contains$default((CharSequence)number, (CharSequence)"0b", (boolean)false, (int)2, null)) {
                return this.getLengthOfSubstringFor(number, (Function1<? super Character, Boolean>)((Function1)calculateNumberLength.2.INSTANCE));
            }
            Iterable $this$any$iv = NumericLiteralLocatorKt.access$getNUMBER_TYPE_CHARACTERS$p();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    char it = ((Character)element$iv).charValue();
                    boolean bl3 = false;
                    if (!StringsKt.contains$default((CharSequence)letters, (char)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            char it;
            char element$iv;
            int n;
            CharSequence $this$count$iv = number;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (n = 0; n < $this$count$iv.length(); ++n) {
                it = element$iv = $this$count$iv.charAt(n);
                boolean bl4 = false;
                if (!Character.isDigit(it)) continue;
                ++count$iv;
            }
            $this$count$iv = number;
            int n2 = count$iv;
            $i$f$count = false;
            count$iv = 0;
            for (n = 0; n < $this$count$iv.length(); ++n) {
                it = element$iv = $this$count$iv.charAt(n);
                boolean bl5 = false;
                if (!NumericLiteralLocatorKt.access$getNUMBER_START_CHARACTERS$p().contains(Character.valueOf(it))) continue;
                ++count$iv;
            }
            int n3 = count$iv;
            return n2 + n3 + 1;
        }
        return number.length();
    }

    /*
     * WARNING - void declaration
     */
    private final int getLengthOfSubstringFor(String number, Function1<? super Character, Boolean> condition) {
        void $this$forEach$iv;
        int hexSequenceLength = 0;
        hexSequenceLength = 2;
        NumericLiteralLocator $this$getLengthOfSubstringFor_u24lambda_u248 = this;
        boolean bl = false;
        String string = number.substring(hexSequenceLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        CharSequence charSequence = string;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl2 = false;
            if (!((Boolean)condition.invoke((Object)Character.valueOf(it))).booleanValue()) break;
            ++hexSequenceLength;
        }
        return hexSequenceLength;
    }
}

