/*
 * Decompiled with CFR 0.152.
 */
package dev.slifer.sizzlecss;

import dev.slifer.sizzlecss.SizzleScript;
import java.io.Serializable;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public abstract class BySizzle
extends By {
    public static By css(String sizzleCssSelector) {
        if (sizzleCssSelector == null) {
            throw new IllegalArgumentException("The selector cannot be null.");
        }
        return new BySizzleCssSelector(sizzleCssSelector);
    }

    public static class BySizzleCssSelector
    extends By
    implements Serializable {
        private String selector;
        private String sizzleScript;

        public BySizzleCssSelector(String selector) {
            this.selector = selector;
            this.sizzleScript = SizzleScript.getInstance().getScript();
        }

        public WebElement findElement(SearchContext context) {
            WebDriver driver = this.getWebDriver(context);
            this.injectSizzleIfNeeded(driver);
            List elements = this.runSizzle(driver);
            if (elements.size() > 0) {
                return (WebElement)elements.get(0);
            }
            throw new NoSuchElementException("Unable to locate element: [" + this.selector + "]");
        }

        public List<WebElement> findElements(SearchContext context) {
            WebDriver driver = this.getWebDriver(context);
            this.injectSizzleIfNeeded(driver);
            return this.runSizzle(driver);
        }

        public String toString() {
            return "BySizzle.css: [" + this.selector + "]";
        }

        private void injectSizzleIfNeeded(WebDriver driver) {
            if (!this.isSizzleLoaded(driver).booleanValue()) {
                ((JavascriptExecutor)driver).executeScript(this.sizzleScript, new Object[0]);
            }
        }

        private Boolean isSizzleLoaded(WebDriver driver) {
            try {
                return (Boolean)((JavascriptExecutor)driver).executeScript("return Sizzle() != null", new Object[0]);
            }
            catch (WebDriverException e) {
                return false;
            }
        }

        private List runSizzle(WebDriver driver) {
            return (List)((JavascriptExecutor)driver).executeScript("return Sizzle(\"" + this.selector + "\")", new Object[0]);
        }
    }
}

