/*
 * Decompiled with CFR 0.152.
 */
package dev.slifer.sizzlecss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;

public class SizzleScript {
    private static SizzleScript sizzleInstance;
    private String script = this.loadSizzle();
    private static final String VERSION = "2.3.4";

    private SizzleScript() {
    }

    public static SizzleScript getInstance() {
        if (sizzleInstance == null) {
            sizzleInstance = new SizzleScript();
        }
        return sizzleInstance;
    }

    public String getScript() {
        return this.script;
    }

    private String loadSizzle() {
        try {
            int line;
            InputStream stream = this.getClass().getResourceAsStream("/META-INF/resources/webjars/sizzle/2.3.4/sizzle.js");
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((line = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, line);
            }
            ((Reader)reader).close();
            String rawSizzle = builder.toString();
            return this.getInjectionScript(rawSizzle);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getInjectionScript(String sizzle) {
        return "if (typeof define !== 'undefined') {var oldDefine = define;define = undefined;" + sizzle + "window.define = oldDefine;} else {" + sizzle + "}";
    }
}

