/*
 * Decompiled with CFR 0.152.
 */
package callStack.utils;

import callStack.utils.ThreadPoolStats;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.Validate;

public abstract class AbstractThreadPool
implements ThreadPoolStats {
    protected ExecutorService m_pool = null;

    public List<String> submitAndGetExceptions(Callable<?> submitMe, int numOfSubmissions) {
        List<String> allExceptions = this.submitAndGetExceptions(this.m_pool, submitMe, numOfSubmissions);
        return allExceptions;
    }

    public <T> List<String> submitAndGetExceptions(List<Callable<T>> submitList) {
        List<String> allExceptions = this.submitAndGetExceptions(this.m_pool, submitList);
        return allExceptions;
    }

    public <T> List<Future<T>> submit(Callable<T> submitMe, int numOfSubmissions) {
        return this.submit(this.m_pool, submitMe, numOfSubmissions);
    }

    public <T> List<Future<T>> submit(List<Callable<T>> listToSubmit) {
        return this.submitAll(this.m_pool, listToSubmit);
    }

    public <T> List<T> submitAndGetResults(List<Callable<T>> listToSubmit) {
        List<Future<T>> futures = this.submitAll(this.m_pool, listToSubmit);
        List<T> results = this.pullOutResults(futures);
        return results;
    }

    private <T> List<T> pullOutResults(List<Future<T>> futures) {
        ArrayList<T> results = new ArrayList<T>();
        for (Future<T> future : futures) {
            try {
                T result = future.get();
                if (result == null) continue;
                results.add(result);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to execute callable.", e);
            }
        }
        return results;
    }

    public <T> List<T> submitAndGetResults(Callable<T> callable, int numOfSubmissions) {
        Validate.notNull(callable);
        Validate.isTrue((numOfSubmissions > 0 ? 1 : 0) != 0, (String)"Must at submit at least 1 callable", (Object[])new Object[0]);
        List<Future<T>> futures = this.submit(callable, numOfSubmissions);
        return this.pullOutResults(futures);
    }

    public void shutdown() {
        this.m_pool.shutdown();
    }

    private <T> List<String> submitAndGetExceptions(ExecutorService executor, Callable<T> callable, int numOfSubmissions) {
        List<Future<T>> futures = this.submit(executor, callable, numOfSubmissions);
        return this.getExceptionsInList(futures);
    }

    private <T> List<Future<T>> submit(ExecutorService executor, Callable<T> callable, int numOfSubmissions) {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(numOfSubmissions);
        int i = 0;
        while (i < numOfSubmissions) {
            futures.add(executor.submit(callable));
            ++i;
        }
        return futures;
    }

    private <T> List<String> getExceptionsInList(List<Future<T>> futures) {
        ArrayList<String> exceptions = new ArrayList<String>(futures.size());
        for (Future<T> future : futures) {
            try {
                future.get();
            }
            catch (Throwable append) {
                exceptions.add(this.getStackTraceFromThrowable(append));
            }
        }
        return exceptions;
    }

    private String getStackTraceFromThrowable(Throwable t) {
        if (t != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            t.printStackTrace(printWriter);
            String stackTrace = writer.toString();
            printWriter.close();
            return stackTrace;
        }
        return null;
    }

    private <T> List<String> submitAndGetExceptions(ExecutorService executor, List<Callable<T>> callables) {
        List<Future<T>> futures = this.submitAll(executor, callables);
        return this.getExceptionsInList(futures);
    }

    private <T> List<Future<T>> submitAll(ExecutorService executor, List<Callable<T>> callables) {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(callables.size());
        for (Callable<T> callable : callables) {
            futures.add(executor.submit(callable));
        }
        return futures;
    }

    public <T> String getExceptions(List<Future<T>> futures) {
        StringBuilder builder = new StringBuilder();
        for (Future<T> future : futures) {
            try {
                future.get();
            }
            catch (Throwable append) {
                builder.append(this.getStackTraceFromThrowable(append));
            }
        }
        return builder.toString();
    }

    @Override
    public int getMaximumPoolSize() {
        if (this.m_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.m_pool).getMaximumPoolSize();
        }
        return 0;
    }

    @Override
    public int getCurrentPoolSize() {
        if (this.m_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.m_pool).getPoolSize();
        }
        return 0;
    }

    @Override
    public int getActivePoolSize() {
        if (this.m_pool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.m_pool).getActiveCount();
        }
        return 0;
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = String.valueOf(name) + "-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

