/*
 * Decompiled with CFR 0.152.
 */
package callStack.profiler;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class ProfileEvent
implements Serializable {
    static final long serialVersionUID = 1L;
    long runtimeInMillis = 0L;
    int numOfInvocations = 0;
    String name;
    long start = -1L;
    boolean isConcurrent = false;
    boolean isRemote = false;
    ProfileEvent parent;
    Map<String, ProfileEvent> childrenAsMap;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final PeriodFormatter periodFormatter = new PeriodFormatterBuilder().appendHours().appendSuffix("h").appendSeparatorIfFieldsBefore(" ").appendMinutes().appendSuffix("m").appendSeparatorIfFieldsBefore(" ").appendSeconds().appendSuffix("s").appendSeparatorIfFieldsBefore(" ").appendMillis3Digit().appendSuffix("ms").toFormatter();

    public Collection<ProfileEvent> getChildren() {
        if (this.childrenAsMap == null) {
            return Collections.emptyList();
        }
        return this.childrenAsMap.values();
    }

    public synchronized void addChild(ProfileEvent child) {
        Validate.notNull((Object)child);
        Validate.notNull((Object)child.getName());
        if (this.childrenAsMap == null) {
            this.childrenAsMap = new ConcurrentHashMap<String, ProfileEvent>();
        }
        this.childrenAsMap.put(child.getName(), child);
        child.setParent(this);
    }

    synchronized void replaceChild(String previousName, ProfileEvent child) {
        this.childrenAsMap.remove(previousName);
        this.childrenAsMap.put(child.getName(), child);
    }

    public ProfileEvent getEvent(String str) {
        Validate.notNull((Object)str);
        ProfileEvent res = null;
        if (this.childrenAsMap != null) {
            res = this.childrenAsMap.get(str);
        }
        return res;
    }

    public void startEvent() {
        if (this.start != -1L) {
            Validate.isTrue((this.start == -1L ? 1 : 0) != 0, (String)("Can not start event twice. Event [" + this.name + "] has already been started"), (Object[])new Object[0]);
        }
        this.start = System.currentTimeMillis();
    }

    public void endEvent() {
        if (this.start == -1L) {
            throw new IllegalArgumentException("Must call startEvent first");
        }
        ++this.numOfInvocations;
        this.runtimeInMillis += System.currentTimeMillis() - this.start;
        this.start = -1L;
    }

    public String prettyPrint() {
        StringBuilder res = new StringBuilder();
        this.buildPrettyString(res, this, "");
        return res.toString();
    }

    private void buildPrettyString(StringBuilder res, ProfileEvent node, String pre) {
        boolean hasChildren;
        if (res.length() > 0) {
            res.append("\n");
        }
        StringBuilder preBuilder = new StringBuilder(pre);
        if (node.isConcurrent) {
            preBuilder.append("|");
        }
        if (node.isRemote) {
            preBuilder.append("||");
        }
        preBuilder.append("|");
        res.append(preBuilder.toString());
        res.append("-> ");
        res.append(node.getName());
        res.append(" (");
        res.append(NUMBER_FORMAT.format(node.getNumOfInvocations()));
        res.append(") : ");
        this.addRuntime(res, node.getRuntimeInMillis());
        boolean bl = hasChildren = node != null && !ProfileEvent.isEmpty(node.getChildrenAsMap());
        if (hasChildren) {
            this.handleUnaccountedTime(res, node);
        }
        if (hasChildren) {
            preBuilder.append("     ");
            for (ProfileEvent profileEvent : node.getChildrenAsMap().values()) {
                this.buildPrettyString(res, profileEvent, preBuilder.toString());
            }
        }
    }

    private static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    private void handleUnaccountedTime(StringBuilder res, ProfileEvent node) {
        List asyncEvents;
        Collection<ProfileEvent> values = node.getChildrenAsMap().values();
        long childrenSum = 0L;
        List syncEvents = values.stream().filter(p -> !this.isConcurrent((ProfileEvent)p)).collect(Collectors.toList());
        if (!syncEvents.isEmpty()) {
            childrenSum += syncEvents.stream().mapToLong(ProfileEvent::getRuntimeInMillis).sum();
        }
        if (!(asyncEvents = values.stream().filter(p -> this.isConcurrent((ProfileEvent)p)).collect(Collectors.toList())).isEmpty()) {
            childrenSum += asyncEvents.stream().mapToLong(ProfileEvent::getRuntimeInMillis).max().getAsLong();
        }
        long diff = node.getRuntimeInMillis() - childrenSum;
        res.append(" [");
        res.append(periodFormatter.print((ReadablePeriod)new Period(diff)));
        res.append("]");
    }

    private boolean isConcurrent(ProfileEvent p) {
        return p.isRemote() || p.isConcurrent();
    }

    private void addRuntime(StringBuilder res, long runtime) {
        res.append(periodFormatter.print((ReadablePeriod)new Period(runtime)));
    }

    public boolean isEnded() {
        return this.start == -1L;
    }

    public String toString() {
        return this.prettyPrint();
    }

    public long getRuntimeInMillis() {
        return this.runtimeInMillis;
    }

    public void setRuntimeInMillis(long runtimeInMillis) {
        this.runtimeInMillis = runtimeInMillis;
    }

    public int getNumOfInvocations() {
        return this.numOfInvocations;
    }

    public void setNumOfInvocations(int numOfInvocations) {
        this.numOfInvocations = numOfInvocations;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    public void setConcurrent(boolean concurrent) {
        this.isConcurrent = concurrent;
    }

    public boolean isRemote() {
        return this.isRemote;
    }

    public void setRemote(boolean remote) {
        this.isRemote = remote;
    }

    public ProfileEvent getParent() {
        return this.parent;
    }

    public void setParent(ProfileEvent parent) {
        this.parent = parent;
    }

    public Map<String, ProfileEvent> getChildrenAsMap() {
        return this.childrenAsMap;
    }

    public void setChildrenAsMap(Map<String, ProfileEvent> childrenAsMap) {
        this.childrenAsMap = childrenAsMap;
    }
}

