/*
 * Decompiled with CFR 0.152.
 */
package callStack.profiler;

import callStack.profiler.CProf;
import callStack.profiler.ProfAsyncResult;
import callStack.profiler.ProfFuture;
import callStack.profiler.ProfileEvent;
import callStack.utils.CachedThreadPool;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfThreadPool
implements GroovyObject {
    private CachedThreadPool cachedThreadPool;
    private boolean assignUniqueNameToEachRootEvent;
    private final String poolName;
    private boolean warnIfFull;
    private static final transient Logger log;
    private static /* synthetic */ BigDecimal $const$0;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ProfThreadPool(String name) {
        String string;
        CachedThreadPool cachedThreadPool;
        MetaClass metaClass;
        boolean bl;
        boolean bl2;
        this.assignUniqueNameToEachRootEvent = bl2 = false;
        this.warnIfFull = bl = true;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.cachedThreadPool = cachedThreadPool = new CachedThreadPool(name);
        this.poolName = string = name;
    }

    public ProfThreadPool(String name, int numThreads) {
        this(name, numThreads, numThreads);
    }

    public ProfThreadPool(String name, int minNumOfThreads, int maxNumOfThreads) {
        String string;
        CachedThreadPool cachedThreadPool;
        MetaClass metaClass;
        boolean bl;
        boolean bl2;
        this.assignUniqueNameToEachRootEvent = bl2 = false;
        this.warnIfFull = bl = true;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.cachedThreadPool = cachedThreadPool = new CachedThreadPool(name, minNumOfThreads, maxNumOfThreads);
        this.poolName = string = name;
    }

    public <T> List<T> asyncExec(List<Callable<T>> listToSubmit) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            List<Callable<T>> list = listToSubmit;
            valueRecorder.record(list, 8);
            if (IndyInterface.bootstrap("cast", "()", 0, list) != false) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert listToSubmit", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        this.warnIfFull(listToSubmit.size());
        Reference profCallables = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _asyncExec_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference profCallables;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _asyncExec_closure1(Object _outerInstance, Object _thisObject, Reference profCallables) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.profCallables = reference = profCallables;
            }

            public Object doCall(Object it) {
                List list = (List)this.profCallables.get();
                ProfCallable profCallable = new ProfCallable();
                Object object = it;
                profCallable.setCallable((Callable)((Object)IndyInterface.bootstrap("cast", "()", 0, object)));
                boolean bl = ((ProfThreadPool)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).getAssignUniqueNameToEachRootEvent();
                profCallable.setUniqueName(bl);
                return list.add((Callable)profCallable);
            }

            @Generated
            public List getProfCallables() {
                return IndyInterface.bootstrap("cast", "()", 0, this.profCallables.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _asyncExec_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(listToSubmit, (Closure)new _asyncExec_closure1(this, this, profCallables));
        List profAsyncResults = this.cachedThreadPool.submitAndGetResults((List)profCallables.get());
        Reference res = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _asyncExec_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference res;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _asyncExec_closure2(Object _outerInstance, Object _thisObject, Reference res) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.res = reference = res;
            }

            public Object doCall(Object it) {
                ((List)this.res.get()).add(((ProfAsyncResult)it).getRes());
                boolean bl = true;
                ((ProfAsyncResult)it).getProfileEvent().setConcurrent(bl);
                Class<CProf> clazz = CProf.class;
                if (IndyInterface.bootstrap("cast", "()", 0, CProf.class != null ? CProf.getParent() : null) != false) {
                    Class<CProf> clazz2 = CProf.class;
                    (CProf.class != null ? CProf.getParent() : null).addChild(((ProfAsyncResult)it).getProfileEvent());
                    return null;
                }
                return null;
            }

            @Generated
            public List getRes() {
                return IndyInterface.bootstrap("cast", "()", 0, this.res.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _asyncExec_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(profAsyncResults, (Closure)new _asyncExec_closure2(this, this, res));
        return (List)res.get();
    }

    private void warnIfFull(int numToSubmit) {
        if (this.warnIfFull) {
            double currentPoolSize = this.cachedThreadPool.getActivePoolSize() + numToSubmit;
            double percentFull = currentPoolSize / (double)this.cachedThreadPool.getMaximumPoolSize();
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)percentFull, (Object)$const$0)) {
                Object v0;
                if (log.isWarnEnabled()) {
                    log.warn("[{}] pool is > 90% full, [{}] current threads", (Object)this.poolName, (Object)((int)currentPoolSize - 1));
                    v0 = null;
                } else {
                    v0 = null;
                }
            }
        }
    }

    public <T> Future<T> submit(Callable<T> callable) {
        this.warnIfFull(1);
        ProfCallable profCallable = new ProfCallable();
        Callable<T> callable2 = callable;
        profCallable.setCallable(callable2);
        boolean bl = this.assignUniqueNameToEachRootEvent;
        profCallable.setUniqueName(bl);
        List<Future<ProfAsyncResult>> futures = this.cachedThreadPool.submit(profCallable, 1);
        ProfFuture profFuture = new ProfFuture();
        Object object = DefaultGroovyMethods.first(futures);
        profFuture.setUnderlyingFuture(IndyInterface.bootstrap("cast", "()", 0, object));
        return profFuture;
    }

    public int getMaximumPoolSize() {
        return this.cachedThreadPool.getMaximumPoolSize();
    }

    public int getCurrentPoolSize() {
        return this.cachedThreadPool.getCurrentPoolSize();
    }

    public int getActivePoolSize() {
        return this.cachedThreadPool.getActivePoolSize();
    }

    public void shutdown() {
        this.cachedThreadPool.shutdown();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ProfThreadPool.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ProfThreadPool.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ProfThreadPool.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public static /* synthetic */ boolean pfaccess$0(ProfThreadPool $that) {
        return $that.assignUniqueNameToEachRootEvent;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProfThreadPool.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        $const$0 = bigDecimal = new BigDecimal("0.9");
    }

    static {
        Logger logger;
        ProfThreadPool.__$swapInit();
        log = logger = LoggerFactory.getLogger((String)"callStack.profiler.ProfThreadPool");
    }

    @Generated
    public CachedThreadPool getCachedThreadPool() {
        return this.cachedThreadPool;
    }

    @Generated
    public void setCachedThreadPool(CachedThreadPool cachedThreadPool) {
        this.cachedThreadPool = cachedThreadPool;
    }

    @Generated
    public boolean getAssignUniqueNameToEachRootEvent() {
        return this.assignUniqueNameToEachRootEvent;
    }

    @Generated
    public boolean isAssignUniqueNameToEachRootEvent() {
        return this.assignUniqueNameToEachRootEvent;
    }

    @Generated
    public void setAssignUniqueNameToEachRootEvent(boolean bl) {
        this.assignUniqueNameToEachRootEvent = bl;
    }

    @Generated
    public final String getPoolName() {
        return this.poolName;
    }

    @Generated
    public boolean getWarnIfFull() {
        return this.warnIfFull;
    }

    @Generated
    public boolean isWarnIfFull() {
        return this.warnIfFull;
    }

    @Generated
    public void setWarnIfFull(boolean bl) {
        this.warnIfFull = bl;
    }

    public static class ProfCallable
    implements Callable<ProfAsyncResult>,
    GroovyObject {
        private Callable callable;
        private boolean uniqueName;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        @Generated
        public ProfCallable() {
            MetaClass metaClass;
            boolean bl;
            this.uniqueName = bl = false;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public ProfAsyncResult call() throws Exception {
            ProfileEvent profileEvent;
            CProf.clear();
            String threadName = Thread.currentThread().getName();
            Object rootEventName = threadName;
            if (this.uniqueName) {
                GStringImpl gStringImpl = new GStringImpl(new Object[]{rootEventName, UUID.randomUUID().toString()}, new String[]{"", "-", ""});
                rootEventName = IndyInterface.bootstrap("cast", "()", 0, gStringImpl);
            }
            Reference o = new Reference(null);
            o.get();
            public final class _call_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference o;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _call_closure1(Object _outerInstance, Object _thisObject, Reference o) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.o = reference = o;
                }

                public Object doCall(Object it) {
                    Object v = ((ProfCallable)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).getCallable().call();
                    this.o.set(v);
                    return v;
                }

                @Generated
                public Object getO() {
                    return this.o.get();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _call_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Object rootEvent = CProf.prof((String)rootEventName, new _call_closure1(this, this, o));
            if (DefaultTypeTransformation.booleanUnbox((Object)rootEvent) && ((profileEvent = rootEvent) != null ? profileEvent.getChildren() : null).size() == 1) {
                Object object = DefaultGroovyMethods.first(((ProfileEvent)rootEvent).getChildren());
                rootEvent = IndyInterface.bootstrap("cast", "()", 0, object);
                String string = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)((ProfileEvent)rootEvent).getName(), (CharSequence)"-"), (CharSequence)threadName);
                ((ProfileEvent)rootEvent).setName(string);
            }
            ProfAsyncResult<Object> profAsyncResult = new ProfAsyncResult<Object>();
            Object object = o.get();
            profAsyncResult.setRes(object);
            Object object2 = rootEvent;
            profAsyncResult.setProfileEvent((ProfileEvent)object2);
            return profAsyncResult;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ProfCallable.class, ProfThreadPool.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ProfCallable.class, ProfThreadPool.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProfThreadPool.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProfThreadPool.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ProfCallable.class, ProfThreadPool.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ProfCallable.class, ProfThreadPool.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ Callable pfaccess$0(ProfCallable $that) {
            return $that.callable;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ProfCallable.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public Callable getCallable() {
            return this.callable;
        }

        @Generated
        public void setCallable(Callable callable) {
            this.callable = callable;
        }

        @Generated
        public boolean getUniqueName() {
            return this.uniqueName;
        }

        @Generated
        public boolean isUniqueName() {
            return this.uniqueName;
        }

        @Generated
        public void setUniqueName(boolean bl) {
            this.uniqueName = bl;
        }
    }
}

