/*
 * Decompiled with CFR 0.152.
 */
package callStack.profiler;

import callStack.profiler.ProfileEvent;
import groovy.lang.Closure;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.Validate;

public class CProf {
    public static final AtomicBoolean turnTreeProfilingOff = new AtomicBoolean(false);
    static final ThreadLocal<Deque<ProfileEvent>> profileEventStack = new ThreadLocal();
    static final ThreadLocal<ProfileEvent> rootEventThreadLocal = new ThreadLocal();
    static final AtomicLong counter = new AtomicLong(0L);
    static final ProfileEvent EMPTY = new ProfileEvent();

    static {
        EMPTY.setName("treeProfilingDisabled");
    }

    public static void clear() {
        rootEventThreadLocal.set(null);
        profileEventStack.set(null);
        counter.set(0L);
    }

    public static void start(String name) {
        Validate.notNull((Object)name);
        Deque<ProfileEvent> stack = profileEventStack.get();
        if (stack == null) {
            stack = new ArrayDeque<ProfileEvent>();
            profileEventStack.set(stack);
        }
        ProfileEvent event = null;
        ProfileEvent parent = CProf.getParent();
        if (parent != null && turnTreeProfilingOff.get()) {
            return;
        }
        if (parent != null) {
            event = parent.getEvent(name);
        }
        if (event == null) {
            event = new ProfileEvent();
            event.setName(name);
            if (parent != null) {
                parent.addChild(event);
            }
        }
        if (stack.isEmpty()) {
            rootEventThreadLocal.set(event);
        }
        stack.push(event);
        event.startEvent();
    }

    public static ProfileEvent getParent() {
        ProfileEvent parent = null;
        Deque<ProfileEvent> stack = profileEventStack.get();
        if (stack != null) {
            parent = stack.peek();
        }
        return parent;
    }

    public static ProfileEvent stop(String name) {
        return CProf.stop(name, true);
    }

    public static ProfileEvent stop(String name, boolean aggregate) {
        boolean stoppingRoot;
        Validate.notNull((Object)name);
        ProfileEvent rootEvent = CProf.getRootEvent();
        boolean bl = stoppingRoot = rootEvent != null && rootEvent.getName().equals(name);
        if (turnTreeProfilingOff.get() && !stoppingRoot) {
            Deque<ProfileEvent> stack = profileEventStack.get();
            while (stack.size() > 1) {
                stack.pop();
            }
            return EMPTY;
        }
        Deque<ProfileEvent> stack = profileEventStack.get();
        if (!stoppingRoot && stack.size() == 1) {
            return EMPTY;
        }
        if (stack == null) {
            Validate.notNull(stack, (String)("Must call start prior calling stop. Name [" + name + "]"), (Object[])new Object[0]);
        }
        ProfileEvent event = stack.pop();
        Validate.notNull((Object)event, (String)"Must call start prior calling stop. Name=$name", (Object[])new Object[0]);
        if (!event.getName().equals(name)) {
            throw new IllegalArgumentException("Current event's name=[" + event.getName() + "] but stop name=[" + name + "]");
        }
        event.endEvent();
        if (!aggregate) {
            String previousName = event.getName();
            event.setName(String.valueOf(event.getName()) + "_" + counter.getAndIncrement());
            if (event.getParent() != null) {
                event.getParent().replaceChild(previousName, event);
            }
        }
        return event;
    }

    public static ProfileEvent prof(String name, Closure profileMe) {
        return CProf.prof(name, true, profileMe);
    }

    public static ProfileEvent prof(String name, boolean aggregate, Closure profileMe) {
        if (!aggregate) {
            name = String.valueOf(name) + "_" + counter.getAndIncrement();
        }
        ProfileEvent res = null;
        CProf.start(name);
        boolean hadExcetpion = false;
        try {
            try {
                profileMe.call();
            }
            catch (Throwable t) {
                hadExcetpion = true;
                throw t;
            }
        }
        finally {
            block11: {
                try {
                    res = CProf.stop(name);
                }
                catch (Throwable stopT) {
                    CProf.clear();
                    if (hadExcetpion) break block11;
                    throw stopT;
                }
            }
        }
        return res;
    }

    public static String prettyPrint() {
        ProfileEvent profileEvent = CProf.getRootEvent();
        if (profileEvent != null) {
            return profileEvent.prettyPrint();
        }
        return "No profiling events";
    }

    public static ProfileEvent getRootEvent() {
        return rootEventThreadLocal.get();
    }

    public static void initRootEvent(ProfileEvent rootEvent) {
        ProfileEvent existing = CProf.getRootEvent();
        if (existing != null) {
            throw new IllegalArgumentException("Root event is already set. Event name is [" + existing.getName() + "]");
        }
        rootEventThreadLocal.set(rootEvent);
        ArrayDeque<ProfileEvent> stack = new ArrayDeque<ProfileEvent>();
        stack.push(rootEvent);
        profileEventStack.set(stack);
    }
}

