/*
 * Decompiled with CFR 0.152.
 */
package dev.shermende.support.spring.factory;

import dev.shermende.support.spring.factory.Factory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.Assert;

public abstract class AbstractFactory<K, C>
implements Factory<K, C> {
    private static final String KEY_NOT_FOUND = "Key '%s' not found";
    private static final String KEY_IS_NULL = "Key is null";
    private static final String CLASS_IS_NULL = "Class is null";
    private final BeanFactory beanFactory;
    private final Map<K, Class<? extends C>> registry = new ConcurrentHashMap<K, Class<? extends C>>();

    protected AbstractFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.registration();
    }

    @Override
    public boolean containsKey(K key) {
        Assert.notNull(key, (String)KEY_IS_NULL);
        return this.registry.containsKey(key);
    }

    @Override
    public void registry(K key, Class<? extends C> aClass) {
        Assert.notNull(key, (String)KEY_IS_NULL);
        Assert.notNull(aClass, (String)CLASS_IS_NULL);
        this.registry.put(key, aClass);
    }

    @Override
    public C getInstance(K key) {
        Assert.notNull(key, (String)KEY_IS_NULL);
        if (this.containsKey(key)) {
            return (C)this.beanFactory.getBean(this.registry.get(key));
        }
        throw new IllegalArgumentException(String.format(KEY_NOT_FOUND, key.toString()));
    }

    protected abstract void registration();
}

