/*
 * Decompiled with CFR 0.152.
 */
package dev.shermende.support.spring.aop.profiling;

import java.lang.reflect.Method;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ProfilingAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProfilingAspect.class);

    @Around(value="@annotation(dev.shermende.support.spring.aop.profiling.annotation.Profiling)")
    public Object profiling(ProceedingJoinPoint proceedingJoinPoint) {
        long start = System.currentTimeMillis();
        Object proceed = proceedingJoinPoint.proceed();
        long delta = System.currentTimeMillis() - start;
        try {
            Class<?> aClass = proceedingJoinPoint.getTarget().getClass();
            MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
            Method method = signature.getMethod();
            log.debug("[Profiling] [{}#{}] [Duration:{}]", new Object[]{aClass.getSimpleName(), method.getName(), delta});
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return proceed;
    }

    @Generated
    public ProfilingAspect() {
    }
}

