/*
 * Decompiled with CFR 0.152.
 */
package dev.shermende.support.spring.aop.logging;

import java.lang.reflect.Method;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class LoggingAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingAspect.class);

    @Around(value="@annotation(dev.shermende.support.spring.aop.logging.annotation.Logging)")
    public Object logging(ProceedingJoinPoint proceedingJoinPoint) {
        try {
            Class<?> aClass = proceedingJoinPoint.getTarget().getClass();
            MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
            Method method = signature.getMethod();
            Object[] args = proceedingJoinPoint.getArgs();
            log.debug("[Logging before] [{}#{}] [Args:{}]", new Object[]{aClass.getSimpleName(), method.getName(), args});
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        Object proceed = proceedingJoinPoint.proceed();
        try {
            Class<?> aClass = proceedingJoinPoint.getTarget().getClass();
            MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
            Method method = signature.getMethod();
            Object[] args = proceedingJoinPoint.getArgs();
            log.debug("[Logging after] [{}#{}] [Args:{}] [Result:{}]", new Object[]{aClass.getSimpleName(), method.getName(), args, proceed});
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return proceed;
    }

    @Generated
    public LoggingAspect() {
    }
}

