/*
 * Decompiled with CFR 0.152.
 */
package dev.shermende.support.spring.aop.intercept;

import dev.shermende.support.spring.aop.intercept.Interceptor;
import dev.shermende.support.spring.aop.intercept.annotation.InterceptArgument;
import java.lang.annotation.Annotation;
import java.util.Optional;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.BeanFactory;

@Aspect
public class InterceptAspect {
    private final BeanFactory beanFactory;

    @Before(value="@annotation(dev.shermende.support.spring.aop.intercept.annotation.Intercept)")
    public void intercept(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Annotation[][] annotations = joinPoint.getTarget().getClass().getMethod(signature.getMethod().getName(), signature.getMethod().getParameterTypes()).getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            for (int j = 0; j < annotations[i].length; ++j) {
                Object arg = joinPoint.getArgs()[i];
                Optional.of(annotations[i][j]).filter(annotation -> annotation.annotationType().equals(InterceptArgument.class)).map(annotation -> (InterceptArgument)annotation).map(interceptArgument -> (Interceptor)this.beanFactory.getBean(interceptArgument.value())).ifPresent(interceptor -> interceptor.doIntercept(arg));
            }
        }
    }

    @Generated
    public InterceptAspect(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

