/*
 * Decompiled with CFR 0.152.
 */
package dev.shermende.support.spring.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Validation;
import org.springframework.util.Assert;
import org.springframework.validation.DataBinder;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

public class ValidationUtil {
    private static final String OBJECT_IS_NULL = "The object to be validated cannot be null";

    private ValidationUtil() {
    }

    public static <T> List<ObjectError> validate(T t) {
        Assert.notNull(t, (String)OBJECT_IS_NULL);
        Set violations = Validation.buildDefaultValidatorFactory().getValidator().validate(t, new Class[0]);
        if (!violations.isEmpty()) {
            return violations.stream().map(violation -> new ObjectError(violation.getPropertyPath().toString(), new String[]{violation.getMessageTemplate()}, violation.getExecutableParameters(), violation.getMessage())).collect(Collectors.toList());
        }
        return new ArrayList<ObjectError>();
    }

    public static <T> List<ObjectError> validate(Validator validator, T t) {
        Assert.notNull(t, (String)OBJECT_IS_NULL);
        Assert.notNull((Object)validator, (String)OBJECT_IS_NULL);
        DataBinder binder = new DataBinder(t);
        binder.addValidators(new Validator[]{validator});
        binder.validate();
        if (binder.getBindingResult().hasErrors()) {
            return binder.getBindingResult().getAllErrors();
        }
        return new ArrayList<ObjectError>();
    }
}

