/*
 * Decompiled with CFR 0.152.
 */
package dev.shermende.support.spring.aop;

import dev.shermende.support.spring.component.InterceptArgumentHolder;
import dev.shermende.support.spring.factory.impl.AnnotationHandlerFactory;
import dev.shermende.support.spring.handler.NonReturnHandler;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AopIntercept {
    private final AnnotationHandlerFactory factory;

    public AopIntercept(AnnotationHandlerFactory factory) {
        this.factory = factory;
    }

    @Before(value="@annotation(dev.shermende.support.spring.component.annotation.Intercept)")
    public void intercept(JoinPoint joinPoint) {
        Annotation[][] annotations;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        try {
            annotations = this.getAnnotations(joinPoint, signature);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        for (int i = 0; i < annotations.length; ++i) {
            for (int j = 0; j < annotations[i].length; ++j) {
                Object arg = joinPoint.getArgs()[i];
                Optional.of(annotations[i][j]).filter(this::canBeHandle).ifPresent(var -> this.handle(arg, (Annotation)var));
            }
        }
    }

    private Annotation[][] getAnnotations(JoinPoint joinPoint, MethodSignature signature) throws NoSuchMethodException {
        return joinPoint.getTarget().getClass().getMethod(this.getMethodName(signature), this.getParameterTypes(signature)).getParameterAnnotations();
    }

    private String getMethodName(MethodSignature signature) {
        return signature.getMethod().getName();
    }

    private Class<?>[] getParameterTypes(MethodSignature signature) {
        return signature.getMethod().getParameterTypes();
    }

    private boolean canBeHandle(Annotation var) {
        return this.factory.containsKey(var.annotationType().getName());
    }

    private void handle(Object arg, Annotation annotation) {
        ((NonReturnHandler)this.factory.getInstance(annotation.annotationType().getName())).handle(new InterceptArgumentHolder().setAnnotation(annotation).setArgument(arg));
    }
}

