/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.lsp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import dev.secondsun.lsp.CancelParams;
import dev.secondsun.lsp.CodeActionParams;
import dev.secondsun.lsp.CodeLens;
import dev.secondsun.lsp.CodeLensParams;
import dev.secondsun.lsp.CompletionItem;
import dev.secondsun.lsp.DidChangeConfigurationParams;
import dev.secondsun.lsp.DidChangeTextDocumentParams;
import dev.secondsun.lsp.DidChangeWatchedFilesParams;
import dev.secondsun.lsp.DidChangeWorkspaceFoldersParams;
import dev.secondsun.lsp.DidCloseTextDocumentParams;
import dev.secondsun.lsp.DidOpenTextDocumentParams;
import dev.secondsun.lsp.DidSaveTextDocumentParams;
import dev.secondsun.lsp.DocumentFormattingParams;
import dev.secondsun.lsp.DocumentLinkParams;
import dev.secondsun.lsp.DocumentSymbolParams;
import dev.secondsun.lsp.FoldingRangeParams;
import dev.secondsun.lsp.InitializeParams;
import dev.secondsun.lsp.LanguageClient;
import dev.secondsun.lsp.LanguageServer;
import dev.secondsun.lsp.Message;
import dev.secondsun.lsp.MessageActionItem;
import dev.secondsun.lsp.PublishDiagnosticsParams;
import dev.secondsun.lsp.ReferenceParams;
import dev.secondsun.lsp.RegistrationParams;
import dev.secondsun.lsp.RenameParams;
import dev.secondsun.lsp.ResponseError;
import dev.secondsun.lsp.ShowMessageParams;
import dev.secondsun.lsp.ShowMessageRequestParams;
import dev.secondsun.lsp.TextDocumentPositionParams;
import dev.secondsun.lsp.WillSaveTextDocumentParams;
import dev.secondsun.lsp.WorkspaceSymbolParams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LSP {
    public static final Gson jsonb = new GsonBuilder().create();
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Logger LOG = Logger.getLogger("main");

    private static String readHeader(InputStream client) {
        StringBuilder line = new StringBuilder();
        char next = LSP.read(client);
        while (true) {
            if (next == '\r') {
                char last = LSP.read(client);
                assert (last == '\n');
                break;
            }
            line.append(next);
            next = LSP.read(client);
        }
        return line.toString();
    }

    private static int parseHeader(String header) {
        String contentLength = "Content-Length: ";
        if (header.startsWith(contentLength)) {
            String tail = header.substring(contentLength.length());
            int length = Integer.parseInt(tail);
            return length;
        }
        return -1;
    }

    private static char read(InputStream client) {
        try {
            int c = client.read();
            if (c == -1) {
                LOG.warning("Stream from client has been closed, throwing kill exception...");
                throw new EndOfStream();
            }
            return (char)c;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String readLength(InputStream client, int byteLength) {
        char next = LSP.read(client);
        while (Character.isWhitespace(next)) {
            next = LSP.read(client);
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (true) {
            result.append(next);
            if (++i == byteLength) break;
            next = LSP.read(client);
        }
        return result.toString();
    }

    public static String nextToken(InputStream client) {
        int contentLength = -1;
        String line;
        while (!(line = LSP.readHeader(client)).isEmpty()) {
            int maybeLength = LSP.parseHeader(line);
            if (maybeLength == -1) continue;
            contentLength = maybeLength;
        }
        return LSP.readLength(client, contentLength);
    }

    public static Message parseMessage(String token) {
        return (Message)jsonb.fromJson(token, Message.class);
    }

    private static void writeClient(OutputStream client, String messageText) {
        byte[] messageBytes = messageText.getBytes(UTF_8);
        String headerText = String.format("Content-Length: %d\r\n\r\n", messageBytes.length);
        byte[] headerBytes = headerText.getBytes(UTF_8);
        try {
            client.write(headerBytes);
            client.write(messageBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJson(Object message) {
        if (message == null) {
            return "null";
        }
        return jsonb.toJson(message);
    }

    public static void respond(OutputStream client, int requestId, Object params) {
        if (params instanceof Optional) {
            Optional option = (Optional)params;
            params = option.orElse(null);
        }
        String jsonText = LSP.toJson(params);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"id\":%d,\"result\":%s}", requestId, jsonText);
        LSP.writeClient(client, messageText);
    }

    private static void notifyClient(OutputStream client, String method, Object params) {
        if (params instanceof Optional) {
            Optional option = (Optional)params;
            params = option.orElse(null);
        }
        String jsonText = LSP.toJson(params);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"method\":\"%s\",\"params\":%s}", method, jsonText);
        LSP.writeClient(client, messageText);
    }

    private static int requestClient(OutputStream client, String method, Object params) {
        if (params instanceof Optional) {
            Optional option = (Optional)params;
            params = option.orElse(null);
        }
        int id = (int)(Math.random() * 20000.0);
        String jsonText = LSP.toJson(params);
        String messageText = String.format("{\"jsonrpc\":\"2.0\",\"method\":\"%s\",\"params\":%s,\"id\":%d}", method, jsonText, id);
        LSP.writeClient(client, messageText);
        return id;
    }

    public static void connect(Function<LanguageClient, LanguageServer> serverFactory, final InputStream receive, OutputStream send) {
        LanguageServer server = serverFactory.apply(new RealClient(send, receive));
        final ArrayBlockingQueue pending = new ArrayBlockingQueue(10);
        final Message endOfStream = new Message();
        class MessageReader
        implements Runnable {
            MessageReader() {
            }

            void peek(Message message) {
                if (message.method != null && message.method.equals("$/cancelRequest")) {
                    CancelParams params = (CancelParams)jsonb.fromJson(message.params.toString(), CancelParams.class);
                    boolean removed = pending.removeIf(r -> r.id != null && r.id.equals(params.id));
                    if (removed) {
                        LOG.info(String.format("Cancelled request %d, which had not yet started", params.id));
                    } else {
                        LOG.info(String.format("Cannot cancel request %d because it has already started", params.id));
                    }
                }
            }

            private boolean kill() {
                LOG.info("Read stream has been closed, putting kill message onto queue...");
                try {
                    pending.put(endOfStream);
                    return true;
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Failed to put kill message onto queue, will try again...", e);
                    return false;
                }
            }

            @Override
            public void run() {
                LOG.info("Placing incoming messages on queue...");
                while (true) {
                    try {
                        while (true) {
                            String token = LSP.nextToken(receive);
                            Message message = LSP.parseMessage(token);
                            this.peek(message);
                            pending.put(message);
                        }
                    }
                    catch (EndOfStream __) {
                        if (!this.kill()) continue;
                        return;
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, e.getMessage(), e);
                        continue;
                    }
                    break;
                }
            }
        }
        Thread reader = new Thread((Runnable)new MessageReader(), "reader");
        reader.setDaemon(true);
        reader.start();
        LOG.info("Reading messages from queue...");
        boolean hasAsyncWork = false;
        block68: while (true) {
            Message r;
            try {
                r = (Message)pending.poll(200L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            if (r == endOfStream) {
                LOG.warning("Stream from client has been closed, exiting...");
                break;
            }
            if (r == null) {
                if (!hasAsyncWork) continue;
                server.doAsyncWork();
                hasAsyncWork = false;
                continue;
            }
            hasAsyncWork = true;
            try {
                if (r.method == null) {
                    Object result = (MessageActionItem)jsonb.fromJson(r.result.toString(), MessageActionItem.class);
                    int id = r.id;
                    if (r.error != null && !r.error.toString().isBlank()) {
                        LOG.severe(r.error.toString());
                        break;
                    }
                    server.handleShowMessageRequestResponse(id, (MessageActionItem)result);
                    break;
                }
                switch (r.method) {
                    case "initialize": {
                        Object params = (InitializeParams)jsonb.fromJson(r.params.toString(), InitializeParams.class);
                        List<Object> response = server.initialize((InitializeParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "initialized": {
                        server.initialized();
                        break;
                    }
                    case "shutdown": {
                        LOG.warning("Got shutdown message");
                        LSP.respond(send, r.id, null);
                        break;
                    }
                    case "exit": {
                        LOG.warning("Got exit message, exiting...");
                        break block68;
                    }
                    case "workspace/didChangeWorkspaceFolders": {
                        Object params = (DidChangeWorkspaceFoldersParams)jsonb.fromJson(r.params.toString(), DidChangeWorkspaceFoldersParams.class);
                        server.didChangeWorkspaceFolders((DidChangeWorkspaceFoldersParams)params);
                        break;
                    }
                    case "workspace/didChangeConfiguration": {
                        Object params = (DidChangeConfigurationParams)jsonb.fromJson(r.params.toString(), DidChangeConfigurationParams.class);
                        server.didChangeConfiguration((DidChangeConfigurationParams)params);
                        break;
                    }
                    case "workspace/didChangeWatchedFiles": {
                        Object params = (DidChangeWatchedFilesParams)jsonb.fromJson(r.params.toString(), DidChangeWatchedFilesParams.class);
                        server.didChangeWatchedFiles((DidChangeWatchedFilesParams)params);
                        break;
                    }
                    case "workspace/symbol": {
                        Object params = (WorkspaceSymbolParams)jsonb.fromJson(r.params.toString(), WorkspaceSymbolParams.class);
                        List<Object> response = server.workspaceSymbols((WorkspaceSymbolParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/documentLink": {
                        Object params = (DocumentLinkParams)jsonb.fromJson(r.params.toString(), DocumentLinkParams.class);
                        List<Object> response = server.documentLink((DocumentLinkParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/didOpen": {
                        Object params = (DidOpenTextDocumentParams)jsonb.fromJson(r.params.toString(), DidOpenTextDocumentParams.class);
                        server.didOpenTextDocument((DidOpenTextDocumentParams)params);
                        break;
                    }
                    case "textDocument/didChange": {
                        Object params = (DidChangeTextDocumentParams)jsonb.fromJson(r.params.toString(), DidChangeTextDocumentParams.class);
                        server.didChangeTextDocument((DidChangeTextDocumentParams)params);
                        break;
                    }
                    case "textDocument/willSave": {
                        Object params = (WillSaveTextDocumentParams)jsonb.fromJson(r.params.toString(), WillSaveTextDocumentParams.class);
                        server.willSaveTextDocument((WillSaveTextDocumentParams)params);
                        break;
                    }
                    case "textDocument/willSaveWaitUntil": {
                        Object params = (WillSaveTextDocumentParams)jsonb.fromJson(r.params.toString(), WillSaveTextDocumentParams.class);
                        List<Object> response = server.willSaveWaitUntilTextDocument((WillSaveTextDocumentParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/didSave": {
                        Object params = (DidSaveTextDocumentParams)jsonb.fromJson(r.params.toString(), DidSaveTextDocumentParams.class);
                        server.didSaveTextDocument((DidSaveTextDocumentParams)params);
                        break;
                    }
                    case "textDocument/didClose": {
                        Object params = (DidCloseTextDocumentParams)jsonb.fromJson(r.params.toString(), DidCloseTextDocumentParams.class);
                        server.didCloseTextDocument((DidCloseTextDocumentParams)params);
                        break;
                    }
                    case "textDocument/completion": {
                        Object params = (TextDocumentPositionParams)jsonb.fromJson(r.params.toString(), TextDocumentPositionParams.class);
                        List<Object> response = server.completion((TextDocumentPositionParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "completionItem/resolve": {
                        Object params = (CompletionItem)jsonb.fromJson(r.params.toString(), CompletionItem.class);
                        List<Object> response = server.resolveCompletionItem((CompletionItem)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/hover": {
                        Object params = (TextDocumentPositionParams)jsonb.fromJson(r.params.toString(), TextDocumentPositionParams.class);
                        List<Object> response = server.hover((TextDocumentPositionParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/signatureHelp": {
                        Object params = (TextDocumentPositionParams)jsonb.fromJson(r.params.toString(), TextDocumentPositionParams.class);
                        List<Object> response = server.signatureHelp((TextDocumentPositionParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/definition": {
                        Object params = (TextDocumentPositionParams)jsonb.fromJson(r.params.toString(), TextDocumentPositionParams.class);
                        List<Object> response = server.gotoDefinition((TextDocumentPositionParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/references": {
                        Object params = (ReferenceParams)jsonb.fromJson(r.params.toString(), ReferenceParams.class);
                        List<Object> response = server.findReferences((ReferenceParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/documentSymbol": {
                        Object params = (DocumentSymbolParams)jsonb.fromJson(r.params.toString(), DocumentSymbolParams.class);
                        List<Object> response = server.documentSymbol((DocumentSymbolParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/codeAction": {
                        Object params = (CodeActionParams)jsonb.fromJson(r.params.toString(), CodeActionParams.class);
                        List<Object> response = server.codeAction((CodeActionParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/codeLens": {
                        Object params = (CodeLensParams)jsonb.fromJson(r.params.toString(), CodeLensParams.class);
                        List<Object> response = server.codeLens((CodeLensParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "codeLens/resolve": {
                        Object params = (CodeLens)jsonb.fromJson(r.params.toString(), CodeLens.class);
                        List<Object> response = server.resolveCodeLens((CodeLens)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/prepareRename": {
                        Object params = (TextDocumentPositionParams)jsonb.fromJson(r.params.toString(), TextDocumentPositionParams.class);
                        List<Object> response = server.prepareRename((TextDocumentPositionParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/rename": {
                        Object params = (RenameParams)jsonb.fromJson(r.params.toString(), RenameParams.class);
                        List<Object> response = server.rename((RenameParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/formatting": {
                        Object params = (DocumentFormattingParams)jsonb.fromJson(r.params.toString(), DocumentFormattingParams.class);
                        List<Object> response = server.formatting((DocumentFormattingParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "textDocument/foldingRange": {
                        Object params = (FoldingRangeParams)jsonb.fromJson(r.params.toString(), FoldingRangeParams.class);
                        List<Object> response = server.foldingRange((FoldingRangeParams)params);
                        LSP.respond(send, r.id, response);
                        break;
                    }
                    case "$/cancelRequest": {
                        break;
                    }
                    default: {
                        LOG.warning(String.format("Don't know what to do with method `%s`", r.method));
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage(), e);
                if (r.id == null) continue;
                LSP.respond(send, r.id, new ResponseError(-32603, e.getMessage(), null));
            }
        }
    }

    static class EndOfStream
    extends RuntimeException {
        EndOfStream() {
        }
    }

    private static class RealClient
    implements LanguageClient {
        final OutputStream send;
        final InputStream recv;

        RealClient(OutputStream send, InputStream recv) {
            this.send = send;
            this.recv = recv;
        }

        @Override
        public void publishDiagnostics(PublishDiagnosticsParams params) {
            LSP.notifyClient(this.send, "textDocument/publishDiagnostics", params);
        }

        @Override
        public void showMessage(ShowMessageParams params) {
            LSP.notifyClient(this.send, "window/showMessage", params);
        }

        @Override
        public void registerCapability(String method, JsonElement options) {
            RegistrationParams params = new RegistrationParams();
            params.id = UUID.randomUUID().toString();
            params.method = method;
            params.registerOptions = options;
            LSP.notifyClient(this.send, "client/registerCapability", params);
        }

        @Override
        public void customNotification(String method, JsonElement params) {
            LSP.notifyClient(this.send, method, params);
        }

        @Override
        public int showMessageRequest(ShowMessageRequestParams requestParams) {
            return LSP.requestClient(this.send, "window/showMessageRequest", requestParams);
        }
    }
}

