/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.util;

import dev.secondsun.geometry.Model;
import dev.secondsun.geometry.Triangle;
import dev.secondsun.geometry.Vertex;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class CubeBuilder {
    private Vertex start;
    private float width;
    private float height;
    private float length;
    private int front1;
    private int front2;
    private int top1;
    private int top2;
    private int back1;
    private int back2;
    private int bottom1;
    private int bottom2;
    private int up1;
    private int up2;
    private int down1;
    private int down2;
    private boolean enableBottom;
    private boolean enableTop;
    private boolean enableUp;
    private boolean enableDown;
    private boolean enableFront;
    private boolean enableBack;

    public CubeBuilder(Vertex start, float width, float height, float length) {
        this.start = start;
        this.width = width;
        this.height = height;
        this.length = length;
        this.down1 = this.down2 = Color.BLACK.getRGB();
        this.up2 = this.down2;
        this.up1 = this.down2;
        this.bottom2 = this.down2;
        this.bottom1 = this.down2;
        this.back2 = this.down2;
        this.back1 = this.down2;
        this.top2 = this.down2;
        this.top1 = this.down2;
        this.front2 = this.down2;
        this.front1 = this.down2;
        this.enableBack = true;
        this.enableFront = true;
        this.enableDown = true;
        this.enableUp = true;
        this.enableTop = true;
        this.enableBottom = true;
    }

    public int getFront1() {
        return this.front1;
    }

    public CubeBuilder setFront1(int front1) {
        this.front1 = front1;
        return this;
    }

    public int getFront2() {
        return this.front2;
    }

    public CubeBuilder setFront2(int front2) {
        this.front2 = front2;
        return this;
    }

    public int getTop1() {
        return this.top1;
    }

    public CubeBuilder setTop1(int top1) {
        this.top1 = top1;
        return this;
    }

    public int getTop2() {
        return this.top2;
    }

    public CubeBuilder setTop2(int top2) {
        this.top2 = top2;
        return this;
    }

    public int getBack1() {
        return this.back1;
    }

    public CubeBuilder setBack1(int back1) {
        this.back1 = back1;
        return this;
    }

    public int getBack2() {
        return this.back2;
    }

    public CubeBuilder setBack2(int back2) {
        this.back2 = back2;
        return this;
    }

    public int getBottom1() {
        return this.bottom1;
    }

    public CubeBuilder setBottom1(int bottom1) {
        this.bottom1 = bottom1;
        return this;
    }

    public int getBottom2() {
        return this.bottom2;
    }

    public CubeBuilder setBottom2(int bottom2) {
        this.bottom2 = bottom2;
        return this;
    }

    public int getUp1() {
        return this.up1;
    }

    public CubeBuilder setUp1(int up1) {
        this.up1 = up1;
        return this;
    }

    public int getUp2() {
        return this.up2;
    }

    public CubeBuilder setUp2(int up2) {
        this.up2 = up2;
        return this;
    }

    public int getDown1() {
        return this.down1;
    }

    public CubeBuilder setDown1(int down1) {
        this.down1 = down1;
        return this;
    }

    public int getDown2() {
        return this.down2;
    }

    public CubeBuilder setDown2(int down2) {
        this.down2 = down2;
        return this;
    }

    public Model cube() {
        final ArrayList<Triangle> triangles = new ArrayList<Triangle>();
        if (this.enableBottom) {
            triangles.add(new Triangle(new Vertex(this.start.x + this.width, this.start.y, this.start.z), new Vertex(this.start.x, this.start.y, this.start.z), new Vertex(this.start.x, this.start.y, this.start.z + this.height), this.bottom1));
            triangles.add(new Triangle(new Vertex(this.start.x, this.start.y, this.start.z + this.height), new Vertex(this.start.x + this.width, this.start.y, this.start.z + this.height), new Vertex(this.start.x + this.width, this.start.y, this.start.z), this.bottom2));
        }
        if (this.enableTop) {
            triangles.add(new Triangle(new Vertex(this.start.x + this.width, this.start.y + this.length, this.start.z), new Vertex(this.start.x, this.start.y + this.length, this.start.z + this.height), new Vertex(this.start.x, this.start.y + this.length, this.start.z), this.top1));
            triangles.add(new Triangle(new Vertex(this.start.x, this.start.y + this.length, this.start.z + this.height), new Vertex(this.start.x + this.width, this.start.y + this.length, this.start.z), new Vertex(this.start.x + this.width, this.start.y + this.length, this.start.z + this.height), this.top2));
        }
        if (this.enableFront) {
            triangles.add(new Triangle(new Vertex(this.start.x + this.width, this.start.y + this.length, this.start.z + this.height), new Vertex(this.start.x + this.width, this.start.y + this.length, this.start.z), new Vertex(this.start.x + this.width, this.start.y, this.start.z), this.front1));
            triangles.add(new Triangle(new Vertex(this.start.x + this.width, this.start.y, this.start.z), new Vertex(this.start.x + this.width, this.start.y, this.start.z + this.height), new Vertex(this.start.x + this.width, this.start.y + this.length, this.start.z + this.height), this.front2));
        }
        if (this.enableBack) {
            triangles.add(new Triangle(new Vertex(this.start.x, this.start.y, this.start.z), new Vertex(this.start.x, this.start.y + this.length, this.start.z), new Vertex(this.start.x, this.start.y + this.length, this.start.z + this.height), this.back1));
            triangles.add(new Triangle(new Vertex(this.start.x, this.start.y + this.length, this.start.z + this.height), new Vertex(this.start.x, this.start.y, this.start.z + this.height), new Vertex(this.start.x, this.start.y, this.start.z), this.back2));
        }
        if (this.enableUp) {
            triangles.add(new Triangle(new Vertex(this.start.x, this.start.y, this.start.z + this.height), new Vertex(this.start.x, this.start.y + this.length, this.start.z + this.height), new Vertex(this.start.x + this.width, this.start.y + this.length, this.start.z + this.height), this.up1));
            triangles.add(new Triangle(new Vertex(this.start.x + this.width, this.start.y + this.length, this.start.z + this.height), new Vertex(this.start.x + this.width, this.start.y, this.start.z + this.height), new Vertex(this.start.x, this.start.y, this.start.z + this.height), this.up2));
        }
        if (this.enableDown) {
            triangles.add(new Triangle(new Vertex(this.start.x + this.width, this.start.y + this.length, this.start.z), new Vertex(this.start.x, this.start.y + this.length, this.start.z), new Vertex(this.start.x, this.start.y, this.start.z), this.down1));
            triangles.add(new Triangle(new Vertex(this.start.x, this.start.y, this.start.z), new Vertex(this.start.x + this.width, this.start.y, this.start.z), new Vertex(this.start.x + this.width, this.start.y + this.length, this.start.z), this.down2));
        }
        return new Model(){

            @Override
            public List<Triangle> getTriangles() {
                return triangles;
            }
        };
    }

    public CubeBuilder disableBottom() {
        this.enableBottom = false;
        return this;
    }

    public CubeBuilder disableTop() {
        this.enableTop = false;
        return this;
    }

    public CubeBuilder disableFront() {
        this.enableFront = false;
        return this;
    }

    public CubeBuilder disableBack() {
        this.enableBack = false;
        return this;
    }

    public CubeBuilder disableUp() {
        this.enableUp = false;
        return this;
    }

    public CubeBuilder disableDown() {
        this.enableDown = false;
        return this;
    }
}

