/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.geometry.playfield;

import dev.secondsun.geometry.Model;
import dev.secondsun.geometry.Triangle;
import dev.secondsun.geometry.Vertex;
import dev.secondsun.util.BSPTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class BoardNew
implements Model {
    private final int boardWidth;
    private final int boardHeight;
    private List<Triangle> tiles;

    public BoardNew(int columns, int rows, int scale, int[] palette) {
        Random random = new Random(columns);
        int tileSize = 8 * scale;
        this.boardWidth = columns * tileSize;
        this.boardHeight = rows * tileSize;
        this.tiles = new ArrayList<Triangle>(rows * columns);
        HashMap<Vertex, Vertex> vertexMap = new HashMap<Vertex, Vertex>();
        for (int x = 0; x < columns; ++x) {
            for (int y = 0; y < rows; ++y) {
                Triangle[] cube;
                int paletteSize = palette.length;
                int paletteColorIndex = (y * tileSize + x) % paletteSize;
                int zOff = random.nextInt(7);
                Vertex v1 = vertexMap.computeIfAbsent(new Vertex(x * tileSize, y * tileSize, zOff * tileSize), point -> new Vertex(point.x - (float)(this.boardWidth / 2), point.y - (float)(this.boardHeight / 2), point.z));
                Vertex v2 = vertexMap.computeIfAbsent(new Vertex(x * tileSize, y * tileSize + tileSize, zOff * tileSize), point -> new Vertex(point.x - (float)(this.boardWidth / 2), point.y - (float)(this.boardHeight / 2), point.z));
                Vertex v3 = vertexMap.computeIfAbsent(new Vertex(x * tileSize + tileSize, y * tileSize + tileSize, zOff * tileSize), point -> new Vertex(point.x - (float)(this.boardWidth / 2), point.y - (float)(this.boardHeight / 2), point.z));
                Vertex v4 = vertexMap.computeIfAbsent(new Vertex(x * tileSize + tileSize, y * tileSize, zOff * tileSize), point -> new Vertex(point.x - (float)(this.boardWidth / 2), point.y - (float)(this.boardHeight / 2), point.z));
                Vertex v5 = vertexMap.computeIfAbsent(new Vertex(x * tileSize, y * tileSize, (zOff + 1) * tileSize), point -> new Vertex(point.x - (float)(this.boardWidth / 2), point.y - (float)(this.boardHeight / 2), point.z));
                Vertex v6 = vertexMap.computeIfAbsent(new Vertex(x * tileSize, y * tileSize + tileSize, (zOff + 1) * tileSize), point -> new Vertex(point.x - (float)(this.boardWidth / 2), point.y - (float)(this.boardHeight / 2), point.z));
                Vertex v7 = vertexMap.computeIfAbsent(new Vertex(x * tileSize + tileSize, y * tileSize + tileSize, (zOff + 1) * tileSize), point -> new Vertex(point.x - (float)(this.boardWidth / 2), point.y - (float)(this.boardHeight / 2), point.z));
                Vertex v8 = vertexMap.computeIfAbsent(new Vertex(x * tileSize + tileSize, y * tileSize, (zOff + 1) * tileSize), point -> new Vertex(point.x - (float)(this.boardWidth / 2), point.y - (float)(this.boardHeight / 2), point.z));
                for (Triangle q : cube = new Triangle[]{new Triangle(v1, v2, v3, palette[paletteColorIndex]), new Triangle(v1, v3, v4, palette[paletteColorIndex]), new Triangle(v4, v3, v7, palette[paletteColorIndex]), new Triangle(v4, v7, v8, palette[paletteColorIndex]), new Triangle(v8, v7, v6, palette[paletteColorIndex]), new Triangle(v8, v6, v5, palette[paletteColorIndex]), new Triangle(v5, v6, v2, palette[paletteColorIndex]), new Triangle(v5, v2, v1, palette[paletteColorIndex]), new Triangle(v2, v6, v7, palette[paletteColorIndex]), new Triangle(v2, v7, v3, palette[paletteColorIndex]), new Triangle(v8, v5, v1, palette[paletteColorIndex]), new Triangle(v8, v1, v4, palette[paletteColorIndex])}) {
                    this.tiles.add(q);
                }
            }
        }
    }

    @Override
    public List<Triangle> getTriangles() {
        return this.tiles;
    }

    @Override
    public BSPTree getBSPTree() {
        return null;
    }
}

