/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import dev.runabout.JsonObject;
import dev.runabout.JsonObjectImpl;
import dev.runabout.RunaboutInstance;
import dev.runabout.annotations.Nullable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class RunaboutScenario {
    private final String method;
    private final String eventId;
    private final String project;
    private final Timestamp datetime;
    private final JsonObject properties;
    private final Collection<RunaboutInstance> instances;

    public RunaboutScenario(String method, String eventId, @Nullable String project, Timestamp datetime, @Nullable JsonObject properties, Collection<RunaboutInstance> instances) {
        this.method = method;
        this.eventId = eventId;
        this.project = project;
        this.datetime = datetime;
        this.properties = properties;
        this.instances = instances;
    }

    public String getMethod() {
        return this.method;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getProject() {
        return this.project;
    }

    public Timestamp getDatetime() {
        return this.datetime;
    }

    public JsonObject getProperties() {
        return this.properties;
    }

    public Collection<RunaboutInstance> getInstances() {
        return this.instances;
    }

    public JsonObject toJsonObject() {
        return this.toJsonObject(JsonObjectImpl::new);
    }

    public JsonObject toJsonObject(Supplier<JsonObject> jsonFactory) {
        List jsonInstances = this.instances.stream().map(instance -> instance.toJsonObject(jsonFactory)).collect(Collectors.toList());
        return jsonFactory.get().put("version", "1.0.0").put("event_id", this.eventId).put("project", this.project).put("datetime", this.datetime.toString()).put("properties", this.properties).put("method", this.method).put("instances", JsonObject.class, jsonInstances);
    }
}

