/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import dev.runabout.JsonObject;
import dev.runabout.JsonObjectImpl;
import dev.runabout.RunaboutApi;
import dev.runabout.RunaboutApiBuilder;
import dev.runabout.RunaboutException;
import dev.runabout.RunaboutListener;
import dev.runabout.RunaboutScenario;
import dev.runabout.annotations.Nullable;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class RunaboutApiImpl
implements RunaboutApi {
    @Nullable
    private final RunaboutListener listener;
    private final long timeout;
    private final HttpClient httpClient;
    private final Supplier<String> tokenSupplier;
    private final Executor executor;
    private final HttpRequest.Builder requestBuilder;
    private final Queue<RunaboutScenario> queue;

    RunaboutApiImpl(RunaboutApiBuilder builder) {
        this.listener = builder.getListener();
        this.timeout = builder.getTimeout();
        this.tokenSupplier = builder.getTokenSupplier();
        this.executor = builder.getExecutor();
        this.queue = builder.getQueue();
        this.httpClient = HttpClient.newBuilder().build();
        this.requestBuilder = HttpRequest.newBuilder().header("Content-Type", "application/json").uri(builder.getUri());
    }

    @Override
    public void ingestScenario(RunaboutScenario scenario) {
        Objects.requireNonNull(scenario.getMethod(), "Scenario cannot be null");
        if (!this.queue.offer(scenario)) {
            this.onError(new RunaboutException("Runabout scenario queue is full"));
        }
        this.executor.execute(new Worker());
    }

    private void ingestScenario(String contents) {
        HttpRequest request = this.requestBuilder.setHeader("Authorization", "Bearer " + this.tokenSupplier.get()).POST(HttpRequest.BodyPublishers.ofString(contents)).build();
        ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.discarding()).orTimeout(this.timeout, TimeUnit.MILLISECONDS).thenApply(HttpResponse::statusCode)).thenAccept(code -> {
            if (code < 200 || code >= 300) {
                this.onError(new RunaboutException("Runabout API error. Error code: " + code));
            }
        });
        this.requestBuilder.setHeader("Authorization", "");
    }

    private void onError(Throwable t) {
        Optional.ofNullable(this.listener).ifPresent(l -> l.onError(t));
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            RunaboutScenario scenario = RunaboutApiImpl.this.queue.poll();
            if (scenario != null) {
                JsonObjectImpl request = new JsonObjectImpl();
                JsonObject scenarioJson = scenario.toJsonObject();
                request.put("scenarios", JsonObject.class, List.of(scenarioJson));
                RunaboutApiImpl.this.ingestScenario(request.toJson());
            }
        }
    }
}

