/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import dev.runabout.DefaultSerializer;
import dev.runabout.JsonObject;
import dev.runabout.RunaboutInput;
import dev.runabout.RunaboutProperties;
import dev.runabout.RunaboutSerializer;
import dev.runabout.RunaboutService;
import dev.runabout.ToRunabout;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class RunaboutServiceImpl<T extends JsonObject>
implements RunaboutService<T> {
    private final boolean excludeSuper;
    private final Consumer<Throwable> throwableConsumer;
    private final Supplier<Method> callerSupplier;
    private final RunaboutSerializer customSerializer;
    private final Supplier<T> jsonFactory;
    private final Supplier<String> datetimeSupplier;
    private final Function<Method, String> methodToStringFunction;
    private final DefaultSerializer defaultSerializer = DefaultSerializer.getInstance();

    RunaboutServiceImpl(boolean excludeSuper, Consumer<Throwable> throwableConsumer, Supplier<Method> callerSupplier, RunaboutSerializer customSerializer, Supplier<T> jsonFactory, Supplier<String> datetimeSupplier, Function<Method, String> methodToStringFunction) {
        this.throwableConsumer = throwableConsumer;
        this.excludeSuper = excludeSuper;
        this.callerSupplier = callerSupplier;
        this.customSerializer = customSerializer;
        this.jsonFactory = jsonFactory;
        this.datetimeSupplier = datetimeSupplier;
        this.methodToStringFunction = methodToStringFunction;
    }

    @Override
    public RunaboutInput serialize(Object object) {
        if (object == null) {
            return DefaultSerializer.getNullInput();
        }
        RunaboutInput input = this.invokeInstanceSerializer(object);
        if (input == null) {
            input = this.invokeSafe(this.customSerializer, object);
        }
        if (input == null) {
            input = this.invokeSafe((Object o) -> this.defaultSerializer.toRunaboutGenericRecursive(o, this::serialize), object);
        }
        return Optional.ofNullable(input).orElseGet(DefaultSerializer::getEmptyInput);
    }

    @Override
    public Method getCallerMethod() {
        return this.callerSupplier.get();
    }

    @Override
    public T toRunaboutJson(Method method, Object ... objects) {
        Objects.requireNonNull(method, "RunaboutService unable to determine caller method.");
        JsonObject json = (JsonObject)this.jsonFactory.get();
        json.put("version", RunaboutProperties.getInstance().getJsonContractVersion());
        json.put("method", this.methodToStringFunction.apply(method));
        json.put("datetime", this.datetimeSupplier.get());
        ArrayList<JsonObject> inputs = new ArrayList<JsonObject>();
        for (Object object : objects) {
            RunaboutInput input = this.serialize(object);
            JsonObject inputJson = (JsonObject)this.jsonFactory.get();
            inputJson.put("type", object.getClass().getCanonicalName());
            inputJson.put("eval", input.getEval());
            inputJson.put("dependencies", String.class, new ArrayList<String>(input.getDependencies()));
            inputs.add(inputJson);
        }
        json.put("inputs", JsonObject.class, inputs);
        return (T)json;
    }

    private RunaboutInput invokeInstanceSerializer(Object object) {
        Class<?> clazz = object.getClass();
        RunaboutInput input = this.invokeInstanceSerializer(object, clazz);
        while (!this.excludeSuper & input == null && clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            input = this.invokeInstanceSerializer(object, clazz);
        }
        return input;
    }

    private RunaboutInput invokeInstanceSerializer(Object object, Class<?> clazz) {
        Set methods = Optional.ofNullable(clazz).map(cls -> {
            HashSet<Method> set = new HashSet<Method>(Set.of(cls.getMethods()));
            set.addAll(Set.of(cls.getDeclaredMethods()));
            return set;
        }).orElseGet(Collections::emptySet);
        return methods.stream().filter(method -> method.isAnnotationPresent(ToRunabout.class)).findFirst().map(method -> this.invokeSafe((Method)method, object)).orElse(null);
    }

    private RunaboutInput invokeSafe(Method method, Object object) {
        RunaboutInput input = null;
        try {
            method.setAccessible(true);
            RunaboutInput tempInput = (RunaboutInput)method.invoke(object, new Object[0]);
            if (RunaboutServiceImpl.validInput(tempInput)) {
                input = tempInput;
            }
        }
        catch (InvocationTargetException e) {
            this.throwableConsumer.accept(e.getCause() != null ? e.getCause() : e);
        }
        catch (Throwable t) {
            this.throwableConsumer.accept(t);
        }
        return input;
    }

    private RunaboutInput invokeSafe(RunaboutSerializer serializer, Object o) {
        RunaboutInput input = null;
        if (serializer != null) {
            try {
                RunaboutInput tempInput = serializer.toRunaboutGeneric(o);
                if (RunaboutServiceImpl.validInput(tempInput)) {
                    input = tempInput;
                }
            }
            catch (Throwable ex) {
                this.throwableConsumer.accept(ex);
            }
        }
        return input;
    }

    private static boolean validInput(RunaboutInput input) {
        return input != null && input.getEval() != null && !input.getEval().isEmpty() && input.getDependencies() != null;
    }
}

