/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.workflow.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.UnsafeByteOperations;
import dev.restate.sdk.Context;
import dev.restate.sdk.ObjectContext;
import dev.restate.sdk.Service;
import dev.restate.sdk.common.BindableService;
import dev.restate.sdk.common.CoreSerdes;
import dev.restate.sdk.common.HandlerType;
import dev.restate.sdk.common.Serde;
import dev.restate.sdk.common.ServiceType;
import dev.restate.sdk.common.StateKey;
import dev.restate.sdk.common.Target;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.common.syscalls.HandlerDefinition;
import dev.restate.sdk.common.syscalls.HandlerSpecification;
import dev.restate.sdk.common.syscalls.InvocationHandler;
import dev.restate.sdk.common.syscalls.ServiceDefinition;
import dev.restate.sdk.serde.jackson.JacksonSerdes;
import dev.restate.sdk.serde.protobuf.ProtobufSerdes;
import dev.restate.sdk.workflow.WorkflowExecutionState;
import dev.restate.sdk.workflow.generated.CompleteDurablePromiseRequest;
import dev.restate.sdk.workflow.generated.DurablePromiseCompletion;
import dev.restate.sdk.workflow.generated.Failure;
import dev.restate.sdk.workflow.generated.GetOutputResponse;
import dev.restate.sdk.workflow.generated.GetStateResponse;
import dev.restate.sdk.workflow.generated.MaybeDurablePromiseCompletion;
import dev.restate.sdk.workflow.generated.MethodOutput;
import dev.restate.sdk.workflow.generated.SetOutputRequest;
import dev.restate.sdk.workflow.generated.SetStateRequest;
import dev.restate.sdk.workflow.generated.WaitDurablePromiseCompletionRequest;
import dev.restate.sdk.workflow.impl.InvokeRequest;
import dev.restate.sdk.workflow.impl.WorkflowContextImpl;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class WorkflowImpl
implements BindableService<Service.Options> {
    public static final Serde<InvokeRequest> INVOKE_REQUEST_SERDE = JacksonSerdes.of(InvokeRequest.class);
    static final Serde<WorkflowExecutionState> WORKFLOW_EXECUTION_STATE_SERDE = JacksonSerdes.of(WorkflowExecutionState.class);
    static final Serde<GetStateResponse> GET_STATE_RESPONSE_SERDE = ProtobufSerdes.of(GetStateResponse.parser());
    static final Serde<SetStateRequest> SET_STATE_REQUEST_SERDE = ProtobufSerdes.of(SetStateRequest.parser());
    static final Serde<WaitDurablePromiseCompletionRequest> WAIT_DURABLE_PROMISE_COMPLETION_REQUEST_SERDE = ProtobufSerdes.of(WaitDurablePromiseCompletionRequest.parser());
    static final Serde<MaybeDurablePromiseCompletion> MAYBE_DURABLE_PROMISE_COMPLETION_SERDE = ProtobufSerdes.of(MaybeDurablePromiseCompletion.parser());
    static final Serde<CompleteDurablePromiseRequest> COMPLETE_DURABLE_PROMISE_REQUEST_SERDE = ProtobufSerdes.of(CompleteDurablePromiseRequest.parser());
    static final Serde<GetOutputResponse> GET_OUTPUT_RESPONSE_SERDE = ProtobufSerdes.of(GetOutputResponse.parser());
    private static final Serde<SetOutputRequest> SET_OUTPUT_REQUEST_SERDE = ProtobufSerdes.of(SetOutputRequest.parser());
    private static final Serde<DurablePromiseCompletion> DURABLE_PROMISE_COMPLETION_SERDE = ProtobufSerdes.of(DurablePromiseCompletion.parser());
    private static final Serde<Set<String>> DURABLEPROMISE_LISTENER_SERDE = JacksonSerdes.of((TypeReference)new TypeReference<Set<String>>(){});
    private static final StateKey<MethodOutput> OUTPUT_KEY = StateKey.of((String)"_output", (Serde)ProtobufSerdes.of(MethodOutput.parser()));
    private static final StateKey<WorkflowExecutionState> WORKFLOW_EXECUTION_STATE_KEY = StateKey.of((String)"_workflow_execution_state", WORKFLOW_EXECUTION_STATE_SERDE);
    private static final String START_HANDLER = "_start";
    private final String name;
    private final Service.Options options;
    private final HandlerDefinition<?, ?, Service.Options> workflowMethod;
    private final HashMap<String, HandlerDefinition<?, ?, Service.Options>> sharedHandlers;

    public WorkflowImpl(String name, Service.Options options, HandlerDefinition<?, ?, Service.Options> workflowMethod, HashMap<String, HandlerDefinition<?, ?, Service.Options>> sharedHandlers) {
        this.name = name;
        this.options = options;
        this.workflowMethod = workflowMethod;
        this.sharedHandlers = sharedHandlers;
    }

    private WorkflowExecutionState submit(Context objectContext, InvokeRequest invokeRequest) {
        WorkflowExecutionState response = (WorkflowExecutionState)((Object)objectContext.call(this.workflowManagerTarget(invokeRequest.getKey(), "tryStart"), CoreSerdes.JSON_STRING, WORKFLOW_EXECUTION_STATE_SERDE, (Object)invokeRequest.getKey()).await());
        if (response.equals((Object)WorkflowExecutionState.STARTED)) {
            objectContext.send(Target.service((String)this.name, (String)START_HANDLER), INVOKE_REQUEST_SERDE, (Object)invokeRequest);
        }
        return response;
    }

    private void internalStart(Context context, InvokeRequest invokeRequest) {
        byte[] valueOutput;
        try {
            Object input = this.workflowMethod.getSpec().getRequestSerde().deserialize(invokeRequest.getPayload().toString().getBytes(StandardCharsets.UTF_8));
            WorkflowContextImpl ctx = new WorkflowContextImpl(context, this.name, invokeRequest.getKey(), true);
            Object output = ((Service.Handler)this.workflowMethod.getHandler()).getRunner().apply(ctx, input);
            valueOutput = this.workflowMethod.getSpec().getResponseSerde().serialize(output);
        }
        catch (TerminalException e) {
            context.send(this.workflowManagerTarget(invokeRequest.getKey(), "setOutput"), SET_OUTPUT_REQUEST_SERDE, (Object)SetOutputRequest.newBuilder().setOutput(MethodOutput.newBuilder().setFailure(Failure.newBuilder().setCode(e.getCode()).setMessage(e.getMessage()))).build());
            throw e;
        }
        context.send(this.workflowManagerTarget(invokeRequest.getKey(), "setOutput"), SET_OUTPUT_REQUEST_SERDE, (Object)SetOutputRequest.newBuilder().setOutput(MethodOutput.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])valueOutput))).build());
    }

    private byte[] invokeSharedMethod(String handlerName, Context context, InvokeRequest request) {
        HandlerDefinition<?, ?, Service.Options> method = this.sharedHandlers.get(handlerName);
        if (method == null) {
            throw new TerminalException(404, "Method " + handlerName + " not found");
        }
        Object input = method.getSpec().getRequestSerde().deserialize(request.getPayload().toString().getBytes(StandardCharsets.UTF_8));
        WorkflowContextImpl ctx = new WorkflowContextImpl(context, this.name, request.getKey(), false);
        Object output = ((Service.Handler)method.getHandler()).getRunner().apply(ctx, input);
        return method.getSpec().getResponseSerde().serialize(output);
    }

    private GetStateResponse getState(ObjectContext context, String key) throws TerminalException {
        return context.get(this.stateKey(key)).map(val -> GetStateResponse.newBuilder().setValue((ByteString)val).build()).orElseGet(() -> GetStateResponse.newBuilder().setEmpty(Empty.getDefaultInstance()).build());
    }

    private void setState(ObjectContext context, SetStateRequest request) throws TerminalException {
        context.set(this.stateKey(request.getStateKey()), (Object)request.getStateValue());
    }

    private void clearState(ObjectContext context, String key) throws TerminalException {
        context.clear(this.stateKey(key));
    }

    private void waitDurablePromiseCompletion(ObjectContext context, WaitDurablePromiseCompletionRequest request) throws TerminalException {
        Optional val = context.get(this.durablePromiseKey(request.getDurablePromiseKey()));
        if (val.isPresent()) {
            this.completeListener(context, request.getAwakeableId(), (DurablePromiseCompletion)val.get());
            return;
        }
        StateKey<Set<String>> listenersKey = this.durablePromiseListenersKey(request.getDurablePromiseKey());
        Set listeners = context.get(listenersKey).orElseGet(HashSet::new);
        listeners.add(request.getAwakeableId());
        context.set(listenersKey, (Object)listeners);
    }

    private MaybeDurablePromiseCompletion getDurablePromiseCompletion(ObjectContext context, String durablePromiseKeyStr) throws TerminalException {
        StateKey<DurablePromiseCompletion> durablePromiseKey = this.durablePromiseKey(durablePromiseKeyStr);
        Optional val = context.get(durablePromiseKey);
        if (val.isEmpty()) {
            return MaybeDurablePromiseCompletion.newBuilder().setNotCompleted(Empty.getDefaultInstance()).build();
        }
        if (((DurablePromiseCompletion)val.get()).hasValue()) {
            return MaybeDurablePromiseCompletion.newBuilder().setValue(((DurablePromiseCompletion)val.get()).getValue()).build();
        }
        return MaybeDurablePromiseCompletion.newBuilder().setFailure(((DurablePromiseCompletion)val.get()).getFailure()).build();
    }

    private void completeDurablePromise(ObjectContext context, CompleteDurablePromiseRequest request) throws TerminalException {
        StateKey<DurablePromiseCompletion> durablePromiseKey = this.durablePromiseKey(request.getDurablePromiseKey());
        Optional val = context.get(durablePromiseKey);
        if (val.isPresent()) {
            throw new TerminalException("Can't complete an already completed durablePromise");
        }
        context.set(durablePromiseKey, (Object)request.getCompletion());
        StateKey<Set<String>> listenersKey = this.durablePromiseListenersKey(request.getDurablePromiseKey());
        Set listeners = context.get(listenersKey).orElse(Collections.emptySet());
        for (String listener : listeners) {
            this.completeListener(context, listener, request.getCompletion());
        }
        context.clear(listenersKey);
    }

    private WorkflowExecutionState tryStart(ObjectContext context) throws TerminalException {
        Optional maybeResponse = context.get(WORKFLOW_EXECUTION_STATE_KEY);
        if (maybeResponse.isPresent()) {
            return (WorkflowExecutionState)((Object)maybeResponse.get());
        }
        context.set(WORKFLOW_EXECUTION_STATE_KEY, (Object)WorkflowExecutionState.ALREADY_STARTED);
        return WorkflowExecutionState.STARTED;
    }

    private GetOutputResponse getOutput(ObjectContext context) throws TerminalException {
        return context.get(OUTPUT_KEY).map(methodOutput -> methodOutput.hasValue() ? GetOutputResponse.newBuilder().setValue(methodOutput.getValue()).build() : GetOutputResponse.newBuilder().setFailure(methodOutput.getFailure()).build()).orElseGet(() -> GetOutputResponse.newBuilder().setNotCompleted(Empty.getDefaultInstance()).build());
    }

    private void setOutput(ObjectContext context, SetOutputRequest request) throws TerminalException {
        context.set(OUTPUT_KEY, (Object)request.getOutput());
        context.set(WORKFLOW_EXECUTION_STATE_KEY, (Object)WorkflowExecutionState.ALREADY_COMPLETED);
    }

    private void cleanup(ObjectContext context) throws TerminalException {
        context.clearAll();
    }

    private StateKey<ByteString> stateKey(String key) {
        return StateKey.of((String)("_state_" + key), (Serde)new Serde<ByteString>(){

            public byte[] serialize(@Nullable ByteString value) {
                return value.toByteArray();
            }

            public ByteString serializeToByteString(@Nullable ByteString value) {
                return value;
            }

            public ByteString deserialize(ByteString byteString) {
                return byteString;
            }

            public ByteString deserialize(byte[] value) {
                return UnsafeByteOperations.unsafeWrap((byte[])value);
            }
        });
    }

    private void completeListener(ObjectContext context, String listener, DurablePromiseCompletion completion) {
        if (completion.hasValue()) {
            context.awakeableHandle(listener).resolve(CoreSerdes.RAW, (Object)completion.getValue().toByteArray());
        } else {
            context.awakeableHandle(listener).reject(completion.getFailure().getMessage());
        }
    }

    private StateKey<DurablePromiseCompletion> durablePromiseKey(String key) {
        return StateKey.of((String)("_durablePromise_" + key), DURABLE_PROMISE_COMPLETION_SERDE);
    }

    private StateKey<Set<String>> durablePromiseListenersKey(String key) {
        return StateKey.of((String)("_durablePromise_listeners_" + key), DURABLEPROMISE_LISTENER_SERDE);
    }

    static String workflowManagerObjectName(String workflowName) {
        return workflowName + "_Manager";
    }

    private Target workflowManagerTarget(String key, String handler) {
        return Target.virtualObject((String)WorkflowImpl.workflowManagerObjectName(this.name), (String)key, (String)handler);
    }

    public Service.Options options() {
        return this.options;
    }

    public List<ServiceDefinition<Service.Options>> definitions() {
        ArrayList<HandlerDefinition> workflowHandlers = new ArrayList<HandlerDefinition>();
        workflowHandlers.add(HandlerDefinition.of((HandlerSpecification)HandlerSpecification.of((String)"submit", (HandlerType)HandlerType.SHARED, INVOKE_REQUEST_SERDE, WORKFLOW_EXECUTION_STATE_SERDE), (InvocationHandler)Service.Handler.of(this::submit)));
        workflowHandlers.add(HandlerDefinition.of((HandlerSpecification)HandlerSpecification.of((String)START_HANDLER, (HandlerType)HandlerType.SHARED, INVOKE_REQUEST_SERDE, (Serde)CoreSerdes.VOID), (InvocationHandler)Service.Handler.of(this::internalStart)));
        for (HandlerDefinition<?, ?, Service.Options> sharedMethod : this.sharedHandlers.values()) {
            workflowHandlers.add(HandlerDefinition.of((HandlerSpecification)HandlerSpecification.of((String)sharedMethod.getSpec().getName(), (HandlerType)HandlerType.SHARED, INVOKE_REQUEST_SERDE, (Serde)CoreSerdes.RAW), (InvocationHandler)Service.Handler.of((context, invokeRequest) -> this.invokeSharedMethod(sharedMethod.getSpec().getName(), (Context)context, (InvokeRequest)invokeRequest))));
        }
        Service workflowManager = Service.virtualObject((String)WorkflowImpl.workflowManagerObjectName(this.name)).withExclusive("getState", CoreSerdes.JSON_STRING, GET_STATE_RESPONSE_SERDE, this::getState).withExclusive("setState", SET_STATE_REQUEST_SERDE, CoreSerdes.VOID, (context, setStateRequest) -> {
            this.setState((ObjectContext)context, (SetStateRequest)setStateRequest);
            return null;
        }).withExclusive("clearState", CoreSerdes.JSON_STRING, CoreSerdes.VOID, (context, s) -> {
            this.clearState((ObjectContext)context, (String)s);
            return null;
        }).withExclusive("waitDurablePromiseCompletion", WAIT_DURABLE_PROMISE_COMPLETION_REQUEST_SERDE, CoreSerdes.VOID, (context, waitDurablePromiseCompletionRequest) -> {
            this.waitDurablePromiseCompletion((ObjectContext)context, (WaitDurablePromiseCompletionRequest)waitDurablePromiseCompletionRequest);
            return null;
        }).withExclusive("getDurablePromiseCompletion", CoreSerdes.JSON_STRING, MAYBE_DURABLE_PROMISE_COMPLETION_SERDE, this::getDurablePromiseCompletion).withExclusive("completeDurablePromise", COMPLETE_DURABLE_PROMISE_REQUEST_SERDE, CoreSerdes.VOID, (context, completeDurablePromiseRequest) -> {
            this.completeDurablePromise((ObjectContext)context, (CompleteDurablePromiseRequest)completeDurablePromiseRequest);
            return null;
        }).withExclusive("tryStart", CoreSerdes.VOID, WORKFLOW_EXECUTION_STATE_SERDE, (context, unused) -> this.tryStart((ObjectContext)context)).withExclusive("getOutput", CoreSerdes.VOID, GET_OUTPUT_RESPONSE_SERDE, (context, unused) -> this.getOutput((ObjectContext)context)).withExclusive("setOutput", SET_OUTPUT_REQUEST_SERDE, CoreSerdes.VOID, (context, setOutputRequest) -> {
            this.setOutput((ObjectContext)context, (SetOutputRequest)setOutputRequest);
            return null;
        }).withExclusive("cleanup", CoreSerdes.VOID, CoreSerdes.VOID, (context, unused) -> {
            this.cleanup((ObjectContext)context);
            return null;
        }).build(this.options);
        return List.of(ServiceDefinition.of((String)this.name, (ServiceType)ServiceType.SERVICE, workflowHandlers), (ServiceDefinition)workflowManager.definitions().get(0));
    }
}

