/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.workflow;

import dev.restate.sdk.Service;
import dev.restate.sdk.common.BindableService;
import dev.restate.sdk.common.HandlerType;
import dev.restate.sdk.common.Serde;
import dev.restate.sdk.common.syscalls.HandlerDefinition;
import dev.restate.sdk.common.syscalls.HandlerSpecification;
import dev.restate.sdk.common.syscalls.InvocationHandler;
import dev.restate.sdk.workflow.WorkflowContext;
import dev.restate.sdk.workflow.WorkflowSharedContext;
import dev.restate.sdk.workflow.impl.WorkflowImpl;
import java.util.HashMap;
import java.util.function.BiFunction;

public final class WorkflowBuilder {
    private final String name;
    private final HandlerDefinition<?, ?, Service.Options> workflowMethod;
    private final HashMap<String, HandlerDefinition<?, ?, Service.Options>> sharedMethods;

    private WorkflowBuilder(String name, HandlerDefinition<?, ?, Service.Options> workflowMethod) {
        this.name = name;
        this.workflowMethod = workflowMethod;
        this.sharedMethods = new HashMap();
    }

    public <REQ, RES> WorkflowBuilder withShared(String name, Serde<REQ> requestSerde, Serde<RES> responseSerde, BiFunction<WorkflowSharedContext, REQ, RES> runner) {
        this.sharedMethods.put(name, HandlerDefinition.of((HandlerSpecification)HandlerSpecification.of((String)name, (HandlerType)HandlerType.SHARED, requestSerde, responseSerde), (InvocationHandler)Service.Handler.of(runner)));
        return this;
    }

    public BindableService<Service.Options> build(Service.Options options) {
        return new WorkflowImpl(this.name, options, this.workflowMethod, this.sharedMethods);
    }

    public static <REQ, RES> WorkflowBuilder named(String name, Serde<REQ> requestSerde, Serde<RES> responseSerde, BiFunction<WorkflowContext, REQ, RES> runner) {
        return new WorkflowBuilder(name, HandlerDefinition.of((HandlerSpecification)HandlerSpecification.of((String)"run", (HandlerType)HandlerType.EXCLUSIVE, requestSerde, responseSerde), (InvocationHandler)Service.Handler.of(runner)));
    }
}

