/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.workflow.impl;

import dev.restate.sdk.Awaitable;
import dev.restate.sdk.Awakeable;
import dev.restate.sdk.AwakeableHandle;
import dev.restate.sdk.Context;
import dev.restate.sdk.RestateRandom;
import dev.restate.sdk.common.CoreSerdes;
import dev.restate.sdk.common.Request;
import dev.restate.sdk.common.Serde;
import dev.restate.sdk.common.StateKey;
import dev.restate.sdk.common.Target;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.common.function.ThrowingSupplier;
import dev.restate.sdk.workflow.DurablePromise;
import dev.restate.sdk.workflow.DurablePromiseHandle;
import dev.restate.sdk.workflow.DurablePromiseKey;
import dev.restate.sdk.workflow.WorkflowContext;
import dev.restate.sdk.workflow.generated.CompleteDurablePromiseRequest;
import dev.restate.sdk.workflow.generated.DurablePromiseCompletion;
import dev.restate.sdk.workflow.generated.Failure;
import dev.restate.sdk.workflow.generated.GetStateResponse;
import dev.restate.sdk.workflow.generated.MaybeDurablePromiseCompletion;
import dev.restate.sdk.workflow.generated.SetStateRequest;
import dev.restate.sdk.workflow.generated.WaitDurablePromiseCompletionRequest;
import dev.restate.sdk.workflow.impl.WorkflowImpl;
import java.time.Duration;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

class WorkflowContextImpl
implements WorkflowContext {
    private final Context ctx;
    private final String workflowFsqn;
    private final String workflowKey;
    private final boolean isExclusive;

    WorkflowContextImpl(Context ctx, String workflowFqsn, String workflowKey, boolean isExclusive) {
        this.ctx = ctx;
        this.workflowFsqn = workflowFqsn;
        this.workflowKey = workflowKey;
        this.isExclusive = isExclusive;
    }

    @Override
    public String workflowKey() {
        return this.workflowKey;
    }

    public Request request() {
        return this.ctx.request();
    }

    @Override
    public <T> Optional<T> get(StateKey<T> key) {
        GetStateResponse response = (GetStateResponse)this.ctx.call(this.workflowManagerTarget("getState"), CoreSerdes.JSON_STRING, WorkflowImpl.GET_STATE_RESPONSE_SERDE, (Object)key.name()).await();
        switch (response.getResultCase()) {
            case VALUE: {
                return Optional.of(key.serde().deserialize(response.getValue()));
            }
            case EMPTY: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unexpected response from WorkflowManager");
    }

    @Override
    public void clear(StateKey<?> key) {
        if (!this.isExclusive) {
            throw new UnsupportedOperationException("Can't perform a state update on a SharedContext");
        }
        this.ctx.send(this.workflowManagerTarget("clearState"), CoreSerdes.JSON_STRING, (Object)key.name());
    }

    @Override
    public <T> void set(StateKey<T> key, @NonNull T value) {
        if (!this.isExclusive) {
            throw new UnsupportedOperationException("Can't perform a state update on a SharedContext");
        }
        this.ctx.send(this.workflowManagerTarget("setState"), WorkflowImpl.SET_STATE_REQUEST_SERDE, (Object)SetStateRequest.newBuilder().setStateKey(key.name()).setStateValue(key.serde().serializeToByteString(value)).build());
    }

    @Override
    public <T> DurablePromise<T> durablePromise(final DurablePromiseKey<T> key) {
        final Awakeable awakeable = this.ctx.awakeable(key.serde());
        this.ctx.send(this.workflowManagerTarget("waitDurablePromiseCompletion"), WorkflowImpl.WAIT_DURABLE_PROMISE_COMPLETION_REQUEST_SERDE, (Object)WaitDurablePromiseCompletionRequest.newBuilder().setDurablePromiseKey(key.name()).setAwakeableId(awakeable.id()).build());
        return new DurablePromise<T>(){

            @Override
            public Awaitable<T> awaitable() {
                return awakeable;
            }

            @Override
            public Optional<T> peek() {
                MaybeDurablePromiseCompletion maybeDurablePromiseCompletion = (MaybeDurablePromiseCompletion)WorkflowContextImpl.this.ctx.call(WorkflowContextImpl.this.workflowManagerTarget("getDurablePromiseCompletion"), CoreSerdes.JSON_STRING, WorkflowImpl.MAYBE_DURABLE_PROMISE_COMPLETION_SERDE, (Object)key.name()).await();
                switch (maybeDurablePromiseCompletion.getResultCase()) {
                    case VALUE: {
                        return Optional.of(key.serde().deserialize(maybeDurablePromiseCompletion.getValue()));
                    }
                    case FAILURE: {
                        throw new TerminalException(maybeDurablePromiseCompletion.getFailure().getCode(), maybeDurablePromiseCompletion.getFailure().getMessage());
                    }
                    case NOT_COMPLETED: {
                        return Optional.empty();
                    }
                }
                throw new IllegalStateException("Unexpected response from WorkflowManager");
            }

            @Override
            public boolean isCompleted() {
                MaybeDurablePromiseCompletion maybeDurablePromiseCompletion = (MaybeDurablePromiseCompletion)WorkflowContextImpl.this.ctx.call(WorkflowContextImpl.this.workflowManagerTarget("getDurablePromiseCompletion"), CoreSerdes.JSON_STRING, WorkflowImpl.MAYBE_DURABLE_PROMISE_COMPLETION_SERDE, (Object)key.name()).await();
                return !maybeDurablePromiseCompletion.hasNotCompleted();
            }
        };
    }

    @Override
    public <T> DurablePromiseHandle<T> durablePromiseHandle(final DurablePromiseKey<T> key) {
        return new DurablePromiseHandle<T>(){

            @Override
            public void resolve(T payload) throws IllegalStateException {
                WorkflowContextImpl.this.ctx.send(WorkflowContextImpl.this.workflowManagerTarget("completeDurablePromise"), WorkflowImpl.COMPLETE_DURABLE_PROMISE_REQUEST_SERDE, (Object)CompleteDurablePromiseRequest.newBuilder().setDurablePromiseKey(key.name()).setCompletion(DurablePromiseCompletion.newBuilder().setValue(key.serde().serializeToByteString(payload))).build());
            }

            @Override
            public void reject(String reason) throws IllegalStateException {
                WorkflowContextImpl.this.ctx.send(WorkflowContextImpl.this.workflowManagerTarget("completeDurablePromise"), WorkflowImpl.COMPLETE_DURABLE_PROMISE_REQUEST_SERDE, (Object)CompleteDurablePromiseRequest.newBuilder().setDurablePromiseKey(key.name()).setCompletion(DurablePromiseCompletion.newBuilder().setFailure(Failure.newBuilder().setCode(2).setMessage(reason))).build());
            }
        };
    }

    public void sleep(Duration duration) {
        this.ctx.sleep(duration);
    }

    public Awaitable<Void> timer(Duration duration) {
        return this.ctx.timer(duration);
    }

    public <T, R> Awaitable<R> call(Target target, Serde<T> inputSerde, Serde<R> outputSerde, T parameter) {
        return this.ctx.call(target, inputSerde, outputSerde, parameter);
    }

    public <T> void send(Target target, Serde<T> inputSerde, T parameter) {
        this.ctx.send(target, inputSerde, parameter);
    }

    public <T> void send(Target target, Serde<T> inputSerde, T parameter, Duration delay) {
        this.ctx.send(target, inputSerde, parameter, delay);
    }

    public <T> T run(String name, Serde<T> serde, ThrowingSupplier<T> action) throws TerminalException {
        return (T)this.ctx.run(name, serde, action);
    }

    public <T> Awakeable<T> awakeable(Serde<T> serde) {
        return this.ctx.awakeable(serde);
    }

    public AwakeableHandle awakeableHandle(String id) {
        return this.ctx.awakeableHandle(id);
    }

    public RestateRandom random() {
        return this.ctx.random();
    }

    private Target workflowManagerTarget(String handler) {
        return Target.virtualObject((String)WorkflowImpl.workflowManagerObjectName(this.workflowFsqn), (String)this.workflowKey, (String)handler);
    }
}

