/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.workflow.template.generated;

import com.google.protobuf.Empty;
import com.google.protobuf.Value;
import dev.restate.sdk.Awaitable;
import dev.restate.sdk.Component;
import dev.restate.sdk.Context;
import dev.restate.sdk.ObjectContext;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.common.syscalls.Syscalls;
import dev.restate.sdk.workflow.generated.InvokeRequest;
import dev.restate.sdk.workflow.generated.SubmitResponse;
import dev.restate.sdk.workflow.template.generated.WorkflowGrpc;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class WorkflowRestate {
    private WorkflowRestate() {
    }

    public static WorkflowRestateClient newClient(Context ctx) {
        return new WorkflowRestateClient(ctx);
    }

    private static final class HandlerAdapter<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp> {
        private final BiFunction<ObjectContext, Req, Resp> handler;

        private HandlerAdapter(BiFunction<ObjectContext, Req, Resp> handler) {
            this.handler = handler;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            responseObserver.onNext(this.handler.apply(ObjectContext.fromSyscalls((Syscalls)Syscalls.current()), request));
            responseObserver.onCompleted();
        }

        private static <Req, Resp> HandlerAdapter<Req, Resp> of(BiFunction<ObjectContext, Req, Resp> handler) {
            return new HandlerAdapter<Req, Resp>(handler);
        }

        private static <Resp> HandlerAdapter<Empty, Resp> of(Function<ObjectContext, Resp> handler) {
            return new HandlerAdapter<Empty, Object>((ctx, e) -> handler.apply((ObjectContext)ctx));
        }

        private static <Req> HandlerAdapter<Req, Empty> of(BiConsumer<ObjectContext, Req> handler) {
            return new HandlerAdapter<Object, Empty>((ctx, req) -> {
                handler.accept((ObjectContext)ctx, (Object)req);
                return Empty.getDefaultInstance();
            });
        }

        private static HandlerAdapter<Empty, Empty> of(Consumer<ObjectContext> handler) {
            return new HandlerAdapter<Empty, Empty>((ctx, req) -> {
                handler.accept((ObjectContext)ctx);
                return Empty.getDefaultInstance();
            });
        }
    }

    public static abstract class WorkflowRestateImplBase
    implements Component {
        public SubmitResponse submit(Context context, InvokeRequest request) throws TerminalException {
            throw new TerminalException(TerminalException.Code.UNIMPLEMENTED);
        }

        public void internalStart(Context context, InvokeRequest request) throws TerminalException {
            throw new TerminalException(TerminalException.Code.UNIMPLEMENTED);
        }

        public Value invokeTemplate(Context context, InvokeRequest request) throws TerminalException {
            throw new TerminalException(TerminalException.Code.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)WorkflowGrpc.getServiceDescriptor()).addMethod(WorkflowGrpc.getSubmitMethod(), ServerCalls.asyncUnaryCall(HandlerAdapter.of(this::submit))).addMethod(WorkflowGrpc.getInternalStartMethod(), ServerCalls.asyncUnaryCall(HandlerAdapter.of(this::internalStart))).addMethod(WorkflowGrpc.getInvokeTemplateMethod(), ServerCalls.asyncUnaryCall(HandlerAdapter.of(this::invokeTemplate))).build();
        }
    }

    public static final class WorkflowRestateDelayedClient {
        private final Context ctx;
        private final Duration delay;

        WorkflowRestateDelayedClient(Context ctx, Duration delay) {
            this.ctx = ctx;
            this.delay = delay;
        }

        public void submit(InvokeRequest request) {
            this.ctx.delayedCall(WorkflowGrpc.getSubmitMethod(), (Object)request, this.delay);
        }

        public void internalStart(InvokeRequest request) {
            this.ctx.delayedCall(WorkflowGrpc.getInternalStartMethod(), (Object)request, this.delay);
        }

        public void invokeTemplate(InvokeRequest request) {
            this.ctx.delayedCall(WorkflowGrpc.getInvokeTemplateMethod(), (Object)request, this.delay);
        }
    }

    public static final class WorkflowRestateOneWayClient {
        private final Context ctx;

        WorkflowRestateOneWayClient(Context ctx) {
            this.ctx = ctx;
        }

        public void submit(InvokeRequest request) {
            this.ctx.oneWayCall(WorkflowGrpc.getSubmitMethod(), (Object)request);
        }

        public void internalStart(InvokeRequest request) {
            this.ctx.oneWayCall(WorkflowGrpc.getInternalStartMethod(), (Object)request);
        }

        public void invokeTemplate(InvokeRequest request) {
            this.ctx.oneWayCall(WorkflowGrpc.getInvokeTemplateMethod(), (Object)request);
        }
    }

    public static final class WorkflowRestateClient {
        private final Context ctx;

        WorkflowRestateClient(Context ctx) {
            this.ctx = ctx;
        }

        public WorkflowRestateOneWayClient oneWay() {
            return new WorkflowRestateOneWayClient(this.ctx);
        }

        public WorkflowRestateDelayedClient delayed(Duration delay) {
            return new WorkflowRestateDelayedClient(this.ctx, delay);
        }

        public Awaitable<SubmitResponse> submit(InvokeRequest request) {
            return this.ctx.call(WorkflowGrpc.getSubmitMethod(), (Object)request);
        }

        public Awaitable<Empty> internalStart(InvokeRequest request) {
            return this.ctx.call(WorkflowGrpc.getInternalStartMethod(), (Object)request);
        }

        public Awaitable<Value> invokeTemplate(InvokeRequest request) {
            return this.ctx.call(WorkflowGrpc.getInvokeTemplateMethod(), (Object)request);
        }
    }
}

