/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.workflow.impl;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import dev.restate.sdk.workflow.impl.WorkflowComponentBundle;
import dev.restate.sdk.workflow.template.generated.WorkflowGrpc;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

class WorkflowMangledDescriptors {
    static final String MANAGER_SERVICE_SUFFIX = "InternalManager";
    private final Descriptors.FileDescriptor outputFileDescriptor;
    private final String workflowServiceFqsn;
    private final String workflowServiceSimpleName;
    private final String workflowManagerServiceFqsn;
    private final String workflowManagerServiceSimpleName;

    private WorkflowMangledDescriptors(Descriptors.FileDescriptor outputFileDescriptor, String workflowServiceFqsn, String workflowServiceSimpleName, String workflowManagerServiceFqsn, String workflowManagerServiceSimpleName) {
        this.outputFileDescriptor = outputFileDescriptor;
        this.workflowServiceFqsn = workflowServiceFqsn;
        this.workflowServiceSimpleName = workflowServiceSimpleName;
        this.workflowManagerServiceFqsn = workflowManagerServiceFqsn;
        this.workflowManagerServiceSimpleName = workflowManagerServiceSimpleName;
    }

    public Descriptors.FileDescriptor getOutputFileDescriptor() {
        return this.outputFileDescriptor;
    }

    public String getWorkflowServiceFqsn() {
        return this.workflowServiceFqsn;
    }

    public String getWorkflowServiceSimpleName() {
        return this.workflowServiceSimpleName;
    }

    public String getWorkflowManagerServiceFqsn() {
        return this.workflowManagerServiceFqsn;
    }

    public String getWorkflowManagerServiceSimpleName() {
        return this.workflowManagerServiceSimpleName;
    }

    public static WorkflowMangledDescriptors mangle(WorkflowComponentBundle workflowServicesBundle) {
        Descriptors.FileDescriptor outputFileDescriptor;
        Descriptors.FileDescriptor templateDescriptor = ((ProtoFileDescriptorSupplier)Objects.requireNonNull(WorkflowGrpc.getServiceDescriptor().getSchemaDescriptor())).getFileDescriptor();
        DescriptorProtos.FileDescriptorProto.Builder protoDescriptorBuilder = DescriptorProtos.FileDescriptorProto.newBuilder(templateDescriptor.toProto());
        String packageName = workflowServicesBundle.getPackageName();
        if (packageName != null) {
            protoDescriptorBuilder.setName(packageName.replaceAll(Pattern.quote("."), "/") + "/workflow.proto");
            protoDescriptorBuilder.setPackage(packageName);
        } else {
            protoDescriptorBuilder.setName("workflow.proto");
            protoDescriptorBuilder.clearPackage();
        }
        String workflowServiceSimpleName = WorkflowMangledDescriptors.mangleWorkflowDescriptor(protoDescriptorBuilder, workflowServicesBundle.getSimpleName(), workflowServicesBundle.getSharedMethods());
        String workflowManagerServiceSimpleName = WorkflowMangledDescriptors.mangleWorkflowManagerDescriptor(protoDescriptorBuilder, workflowServicesBundle.getSimpleName());
        String workflowServiceFqcn = packageName == null ? workflowServiceSimpleName : packageName + "." + workflowServiceSimpleName;
        String workflowManagerServiceFqcn = packageName == null ? workflowManagerServiceSimpleName : packageName + "." + workflowManagerServiceSimpleName;
        try {
            outputFileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)protoDescriptorBuilder.build(), (Descriptors.FileDescriptor[])templateDescriptor.getDependencies().toArray(new Descriptors.FileDescriptor[0]));
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new RuntimeException(e);
        }
        return new WorkflowMangledDescriptors(outputFileDescriptor, workflowServiceFqcn, workflowServiceSimpleName, workflowManagerServiceFqcn, workflowManagerServiceSimpleName);
    }

    private static String mangleWorkflowDescriptor(DescriptorProtos.FileDescriptorProto.Builder protoDescriptorBuilder, String newSimpleName, Set<String> methods) {
        DescriptorProtos.ServiceDescriptorProto.Builder serviceDescriptorBuilder = protoDescriptorBuilder.getServiceBuilder(0);
        serviceDescriptorBuilder.setName(newSimpleName);
        assert (serviceDescriptorBuilder.getMethodCount() == 3);
        DescriptorProtos.MethodDescriptorProto invokeTemplateMethodDesc = serviceDescriptorBuilder.getMethod(2);
        serviceDescriptorBuilder.removeMethod(2);
        for (String method : methods) {
            serviceDescriptorBuilder.addMethod(invokeTemplateMethodDesc.toBuilder().setName(method));
        }
        protoDescriptorBuilder.setService(0, serviceDescriptorBuilder);
        return newSimpleName;
    }

    private static String mangleWorkflowManagerDescriptor(DescriptorProtos.FileDescriptorProto.Builder protoDescriptorBuilder, String prefix) {
        String newServiceName = prefix + MANAGER_SERVICE_SUFFIX;
        protoDescriptorBuilder.setService(1, protoDescriptorBuilder.getServiceBuilder(1).setName(newServiceName));
        return newServiceName;
    }
}

