/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.workflow.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Empty;
import com.google.protobuf.UnsafeByteOperations;
import dev.restate.sdk.ObjectContext;
import dev.restate.sdk.common.BlockingComponent;
import dev.restate.sdk.common.CoreSerdes;
import dev.restate.sdk.common.Serde;
import dev.restate.sdk.common.StateKey;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.serde.jackson.JacksonSerdes;
import dev.restate.sdk.workflow.generated.CompleteDurablePromiseRequest;
import dev.restate.sdk.workflow.generated.DurablePromiseCompletion;
import dev.restate.sdk.workflow.generated.GetDurablePromiseCompletionRequest;
import dev.restate.sdk.workflow.generated.GetOutputResponse;
import dev.restate.sdk.workflow.generated.GetStateResponse;
import dev.restate.sdk.workflow.generated.MaybeDurablePromiseCompletion;
import dev.restate.sdk.workflow.generated.MethodOutput;
import dev.restate.sdk.workflow.generated.OutputRequest;
import dev.restate.sdk.workflow.generated.SetOutputRequest;
import dev.restate.sdk.workflow.generated.SetStateRequest;
import dev.restate.sdk.workflow.generated.StartRequest;
import dev.restate.sdk.workflow.generated.StartResponse;
import dev.restate.sdk.workflow.generated.StateRequest;
import dev.restate.sdk.workflow.generated.WaitDurablePromiseCompletionRequest;
import dev.restate.sdk.workflow.generated.WorkflowExecutionState;
import dev.restate.sdk.workflow.generated.WorkflowManagerRequest;
import dev.restate.sdk.workflow.impl.DescriptorUtils;
import dev.restate.sdk.workflow.template.generated.WorkflowManagerRestate;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class WorkflowManagerImpl
extends WorkflowManagerRestate.WorkflowManagerRestateImplBase {
    private static final Serde<DurablePromiseCompletion> DURABLEPROMISE_COMPLETION_SERDE = CoreSerdes.ofProtobuf(DurablePromiseCompletion.parser());
    private static final Serde<Set<String>> DURABLEPROMISE_LISTENER_SERDE = JacksonSerdes.of((TypeReference)new TypeReference<Set<String>>(){});
    private static final StateKey<MethodOutput> OUTPUT_KEY = StateKey.of((String)"_output", (Serde)CoreSerdes.ofProtobuf(MethodOutput.parser()));
    private static final StateKey<StartResponse> WORKFLOW_EXECUTION_STATE_KEY = StateKey.of((String)"_workflow_execution_state", (Serde)CoreSerdes.ofProtobuf(StartResponse.parser()));

    WorkflowManagerImpl() {
    }

    @Override
    public GetStateResponse getState(ObjectContext context, StateRequest request) throws TerminalException {
        return context.get(this.stateKey(request.getStateKey())).map(val -> GetStateResponse.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])val)).build()).orElseGet(() -> GetStateResponse.newBuilder().setEmpty(Empty.getDefaultInstance()).build());
    }

    @Override
    public void setState(ObjectContext context, SetStateRequest request) throws TerminalException {
        context.set(this.stateKey(request.getStateKey()), (Object)request.getStateValue().toByteArray());
    }

    @Override
    public void clearState(ObjectContext context, StateRequest request) throws TerminalException {
        context.clear(this.stateKey(request.getStateKey()));
    }

    private StateKey<byte[]> stateKey(String key) {
        return StateKey.raw((String)("_state_" + key));
    }

    @Override
    public void waitDurablePromiseCompletion(ObjectContext context, WaitDurablePromiseCompletionRequest request) throws TerminalException {
        Optional val = context.get(this.durablePromiseKey(request.getDurablePromiseKey()));
        if (val.isPresent()) {
            this.completeListener(context, request.getAwakeableId(), (DurablePromiseCompletion)val.get());
            return;
        }
        StateKey<Set<String>> listenersKey = this.durablePromiseListenersKey(request.getDurablePromiseKey());
        Set listeners = context.get(listenersKey).orElseGet(HashSet::new);
        listeners.add(request.getAwakeableId());
        context.set(listenersKey, (Object)listeners);
    }

    @Override
    public MaybeDurablePromiseCompletion getDurablePromiseCompletion(ObjectContext context, GetDurablePromiseCompletionRequest request) throws TerminalException {
        StateKey<DurablePromiseCompletion> durablePromiseKey = this.durablePromiseKey(request.getDurablePromiseKey());
        Optional val = context.get(durablePromiseKey);
        if (val.isEmpty()) {
            return MaybeDurablePromiseCompletion.newBuilder().setNotCompleted(Empty.getDefaultInstance()).build();
        }
        if (((DurablePromiseCompletion)val.get()).hasValue()) {
            return MaybeDurablePromiseCompletion.newBuilder().setValue(((DurablePromiseCompletion)val.get()).getValue()).build();
        }
        return MaybeDurablePromiseCompletion.newBuilder().setFailure(((DurablePromiseCompletion)val.get()).getFailure()).build();
    }

    @Override
    public void completeDurablePromise(ObjectContext context, CompleteDurablePromiseRequest request) throws TerminalException {
        StateKey<DurablePromiseCompletion> durablePromiseKey = this.durablePromiseKey(request.getDurablePromiseKey());
        Optional val = context.get(durablePromiseKey);
        if (val.isPresent()) {
            throw new TerminalException("Can't complete an already completed durablePromise");
        }
        context.set(durablePromiseKey, (Object)request.getCompletion());
        StateKey<Set<String>> listenersKey = this.durablePromiseListenersKey(request.getDurablePromiseKey());
        Set listeners = context.get(listenersKey).orElse(Collections.emptySet());
        for (String listener : listeners) {
            this.completeListener(context, listener, request.getCompletion());
        }
        context.clear(listenersKey);
    }

    private void completeListener(ObjectContext context, String listener, DurablePromiseCompletion completion) {
        if (completion.hasValue()) {
            context.awakeableHandle(listener).resolve(CoreSerdes.RAW, (Object)completion.getValue().toByteArray());
        } else {
            context.awakeableHandle(listener).reject(completion.getFailure().getMessage());
        }
    }

    @Override
    public StartResponse tryStart(ObjectContext context, StartRequest request) throws TerminalException {
        Optional maybeResponse = context.get(WORKFLOW_EXECUTION_STATE_KEY);
        if (maybeResponse.isPresent()) {
            return (StartResponse)maybeResponse.get();
        }
        context.set(WORKFLOW_EXECUTION_STATE_KEY, (Object)StartResponse.newBuilder().setState(WorkflowExecutionState.ALREADY_STARTED).build());
        return StartResponse.newBuilder().setState(WorkflowExecutionState.STARTED).build();
    }

    @Override
    public GetOutputResponse getOutput(ObjectContext context, OutputRequest request) throws TerminalException {
        return context.get(OUTPUT_KEY).map(methodOutput -> methodOutput.hasValue() ? GetOutputResponse.newBuilder().setValue(methodOutput.getValue()).build() : GetOutputResponse.newBuilder().setFailure(methodOutput.getFailure()).build()).orElseGet(() -> GetOutputResponse.newBuilder().setNotCompleted(Empty.getDefaultInstance()).build());
    }

    @Override
    public void setOutput(ObjectContext context, SetOutputRequest request) throws TerminalException {
        context.set(OUTPUT_KEY, (Object)request.getOutput());
        context.set(WORKFLOW_EXECUTION_STATE_KEY, (Object)StartResponse.newBuilder().setState(WorkflowExecutionState.ALREADY_COMPLETED).build());
    }

    @Override
    public void cleanup(ObjectContext context, WorkflowManagerRequest request) throws TerminalException {
        context.clearAll();
    }

    private StateKey<DurablePromiseCompletion> durablePromiseKey(String key) {
        return StateKey.of((String)("_durablePromise_" + key), DURABLEPROMISE_COMPLETION_SERDE);
    }

    private StateKey<Set<String>> durablePromiseListenersKey(String key) {
        return StateKey.of((String)("_durablePromise_listeners_" + key), DURABLEPROMISE_LISTENER_SERDE);
    }

    static BlockingComponent create(Descriptors.FileDescriptor outputFileDescriptor, String simpleName, String fqsn) {
        WorkflowManagerImpl workflowManager = new WorkflowManagerImpl();
        ServerServiceDefinition originalDefinition = workflowManager.bindService();
        DescriptorUtils.AdapterServiceDescriptorSupplier adapterDescriptorSupplier = new DescriptorUtils.AdapterServiceDescriptorSupplier(outputFileDescriptor, simpleName);
        ServiceDescriptor.Builder grpcServiceDescriptorBuilder = ServiceDescriptor.newBuilder((String)fqsn).setSchemaDescriptor((Object)adapterDescriptorSupplier);
        HashMap<String, MethodDescriptor> methods = new HashMap<String, MethodDescriptor>();
        for (MethodDescriptor originalMethodDescriptor : originalDefinition.getServiceDescriptor().getMethods()) {
            MethodDescriptor newMethodDescriptor = originalMethodDescriptor.toBuilder().setSchemaDescriptor((Object)new DescriptorUtils.AdapterMethodDescriptorSupplier(outputFileDescriptor, simpleName, originalMethodDescriptor.getBareMethodName())).setFullMethodName(MethodDescriptor.generateFullMethodName((String)fqsn, (String)Objects.requireNonNull(originalMethodDescriptor.getBareMethodName()))).build();
            methods.put(originalMethodDescriptor.getBareMethodName(), newMethodDescriptor);
            grpcServiceDescriptorBuilder.addMethod(newMethodDescriptor);
        }
        ServiceDescriptor grpcServiceDescriptor = grpcServiceDescriptorBuilder.build();
        ServerServiceDefinition.Builder serverServiceDefinitionBuilder = ServerServiceDefinition.builder((ServiceDescriptor)grpcServiceDescriptor);
        for (ServerMethodDefinition method : originalDefinition.getMethods()) {
            serverServiceDefinitionBuilder.addMethod((MethodDescriptor)methods.get(method.getMethodDescriptor().getBareMethodName()), method.getServerCallHandler());
        }
        ServerServiceDefinition result = serverServiceDefinitionBuilder.build();
        return () -> result;
    }
}

