/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.workflow.impl;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Empty;
import com.google.protobuf.Value;
import dev.restate.sdk.Component;
import dev.restate.sdk.ObjectContext;
import dev.restate.sdk.common.Serde;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.common.syscalls.Syscalls;
import dev.restate.sdk.dynrpc.CodegenUtils;
import dev.restate.sdk.workflow.generated.Failure;
import dev.restate.sdk.workflow.generated.InvokeRequest;
import dev.restate.sdk.workflow.generated.MethodOutput;
import dev.restate.sdk.workflow.generated.SetOutputRequest;
import dev.restate.sdk.workflow.generated.StartRequest;
import dev.restate.sdk.workflow.generated.StartResponse;
import dev.restate.sdk.workflow.generated.SubmitResponse;
import dev.restate.sdk.workflow.generated.WorkflowExecutionState;
import dev.restate.sdk.workflow.impl.DescriptorUtils;
import dev.restate.sdk.workflow.impl.WorkflowCodegenUtil;
import dev.restate.sdk.workflow.impl.WorkflowComponentBundle;
import dev.restate.sdk.workflow.impl.WorkflowContextImpl;
import dev.restate.sdk.workflow.impl.WorkflowMangledDescriptors;
import dev.restate.sdk.workflow.template.generated.WorkflowGrpc;
import dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class WorkflowImpl
implements Component {
    private final WorkflowComponentBundle workflowServicesBundle;
    private final ServerServiceDefinition serverServiceDefinition;
    private final MethodDescriptor<StartRequest, StartResponse> workflowManagerTryStart;
    private final MethodDescriptor<SetOutputRequest, Empty> workflowManagerSetOutput;
    private final MethodDescriptor<InvokeRequest, Empty> workflowInternalStart;

    WorkflowImpl(WorkflowComponentBundle workflowServicesBundle, WorkflowMangledDescriptors mangledDescriptors) {
        this.workflowServicesBundle = workflowServicesBundle;
        this.serverServiceDefinition = this.buildWorfklowServerServiceDefinition(mangledDescriptors.getOutputFileDescriptor(), mangledDescriptors.getWorkflowServiceSimpleName(), mangledDescriptors.getWorkflowServiceFqsn(), workflowServicesBundle.getSharedMethods());
        this.workflowManagerTryStart = WorkflowCodegenUtil.generateMethodDescriptorForWorkflowManager(WorkflowManagerGrpc.getTryStartMethod(), workflowServicesBundle.getName());
        this.workflowManagerSetOutput = WorkflowCodegenUtil.generateMethodDescriptorForWorkflowManager(WorkflowManagerGrpc.getSetOutputMethod(), workflowServicesBundle.getName());
        this.workflowInternalStart = WorkflowCodegenUtil.generateMethodDescriptorForWorkflowInternalStart(workflowServicesBundle.getName());
    }

    public final ServerServiceDefinition bindService() {
        return this.serverServiceDefinition;
    }

    private void submit(ObjectContext objectContext, InvokeRequest invokeRequest, StreamObserver<SubmitResponse> streamObserver) {
        StartResponse response = (StartResponse)objectContext.call(this.workflowManagerTryStart, (Object)StartRequest.newBuilder().setKey(invokeRequest.getKey()).build()).await();
        if (response.getState().equals((Object)WorkflowExecutionState.STARTED)) {
            objectContext.oneWayCall(this.workflowInternalStart, (Object)invokeRequest);
        }
        this.replySuccess(SubmitResponse.newBuilder().setState(response.getState()).build(), streamObserver);
    }

    private void internalStart(ObjectContext objectContext, InvokeRequest invokeRequest, StreamObserver<Empty> streamObserver) {
        Value valueOutput;
        try {
            Object input = CodegenUtils.valueToT((Serde)this.workflowServicesBundle.getSig().getRequestSerde(), (Value)invokeRequest.getPayload());
            WorkflowContextImpl ctx = new WorkflowContextImpl(this.workflowServicesBundle.getName(), objectContext, invokeRequest.getKey(), true);
            Object output = this.workflowServicesBundle.getRunner().apply(ctx, input);
            valueOutput = CodegenUtils.tToValue((Serde)this.workflowServicesBundle.getSig().getResponseSerde(), output);
        }
        catch (TerminalException e) {
            objectContext.oneWayCall(this.workflowManagerSetOutput, (Object)SetOutputRequest.newBuilder().setKey(invokeRequest.getKey()).setOutput(MethodOutput.newBuilder().setFailure(Failure.newBuilder().setCode(e.getCode().value()).setMessage(e.getMessage()))).build());
            throw e;
        }
        objectContext.oneWayCall(this.workflowManagerSetOutput, (Object)SetOutputRequest.newBuilder().setKey(invokeRequest.getKey()).setOutput(MethodOutput.newBuilder().setValue(valueOutput)).build());
        this.replySuccess(Empty.getDefaultInstance(), streamObserver);
    }

    private void invokeSharedMethod(String methodName, ObjectContext context, InvokeRequest request, StreamObserver<Value> streamObserver) {
        WorkflowComponentBundle.Method<?, ?> method = this.workflowServicesBundle.getSharedMethod(methodName);
        if (method == null) {
            throw new TerminalException(TerminalException.Code.NOT_FOUND, "Method " + methodName + " not found");
        }
        Object input = CodegenUtils.valueToT((Serde)method.getMethodSignature().getRequestSerde(), (Value)request.getPayload());
        WorkflowContextImpl ctx = new WorkflowContextImpl(this.workflowServicesBundle.getName(), context, request.getKey(), false);
        Object output = method.run(ctx, input);
        this.replySuccess(CodegenUtils.tToValue((Serde)method.getMethodSignature().getResponseSerde(), output), streamObserver);
    }

    private <T> void replySuccess(T value, StreamObserver<T> streamObserver) {
        streamObserver.onNext(value);
        streamObserver.onCompleted();
    }

    private ServerServiceDefinition buildWorfklowServerServiceDefinition(Descriptors.FileDescriptor outputFileDescriptor, String simpleName, String fqsn, Set<String> methodNames) {
        DescriptorUtils.AdapterServiceDescriptorSupplier adapterDescriptorSupplier = new DescriptorUtils.AdapterServiceDescriptorSupplier(outputFileDescriptor, simpleName);
        ServiceDescriptor.Builder grpcServiceDescriptorBuilder = ServiceDescriptor.newBuilder((String)fqsn).setSchemaDescriptor((Object)adapterDescriptorSupplier);
        List methodDescriptors = List.copyOf(WorkflowGrpc.getServiceDescriptor().getMethods());
        assert (methodDescriptors.size() == 3);
        MethodDescriptor submitMethodDescriptor = ((MethodDescriptor)methodDescriptors.get(0)).toBuilder().setSchemaDescriptor((Object)new DescriptorUtils.AdapterMethodDescriptorSupplier(outputFileDescriptor, simpleName, ((MethodDescriptor)methodDescriptors.get(0)).getBareMethodName())).setFullMethodName(MethodDescriptor.generateFullMethodName((String)fqsn, (String)((MethodDescriptor)methodDescriptors.get(0)).getBareMethodName())).build();
        grpcServiceDescriptorBuilder.addMethod(submitMethodDescriptor);
        MethodDescriptor internalStartMethodDescriptor = ((MethodDescriptor)methodDescriptors.get(1)).toBuilder().setSchemaDescriptor((Object)new DescriptorUtils.AdapterMethodDescriptorSupplier(outputFileDescriptor, simpleName, ((MethodDescriptor)methodDescriptors.get(1)).getBareMethodName())).setFullMethodName(MethodDescriptor.generateFullMethodName((String)fqsn, (String)((MethodDescriptor)methodDescriptors.get(1)).getBareMethodName())).build();
        grpcServiceDescriptorBuilder.addMethod(internalStartMethodDescriptor);
        MethodDescriptor invokeTemplateDescriptor = (MethodDescriptor)methodDescriptors.get(2);
        HashMap<String, MethodDescriptor> methods = new HashMap<String, MethodDescriptor>();
        for (String methodName : methodNames) {
            MethodDescriptor newMethodDescriptor = invokeTemplateDescriptor.toBuilder().setSchemaDescriptor((Object)new DescriptorUtils.AdapterMethodDescriptorSupplier(outputFileDescriptor, simpleName, methodName)).setFullMethodName(MethodDescriptor.generateFullMethodName((String)fqsn, (String)methodName)).build();
            methods.put(methodName, newMethodDescriptor);
            grpcServiceDescriptorBuilder.addMethod(newMethodDescriptor);
        }
        ServiceDescriptor grpcServiceDescriptor = grpcServiceDescriptorBuilder.build();
        ServerServiceDefinition.Builder serverServiceDefinitionBuilder = ServerServiceDefinition.builder((ServiceDescriptor)grpcServiceDescriptor);
        serverServiceDefinitionBuilder.addMethod(submitMethodDescriptor, ServerCalls.asyncUnaryCall((invokeRequest, streamObserver) -> this.submit(ObjectContext.fromSyscalls((Syscalls)Syscalls.current()), (InvokeRequest)invokeRequest, (StreamObserver<SubmitResponse>)streamObserver)));
        serverServiceDefinitionBuilder.addMethod(internalStartMethodDescriptor, ServerCalls.asyncUnaryCall((invokeRequest, streamObserver) -> this.internalStart(ObjectContext.fromSyscalls((Syscalls)Syscalls.current()), (InvokeRequest)invokeRequest, (StreamObserver<Empty>)streamObserver)));
        for (Map.Entry method : methods.entrySet()) {
            MethodDescriptor desc = (MethodDescriptor)methods.get(method.getKey());
            ServerCallHandler handler = ServerCalls.asyncUnaryCall((invokeRequest, streamObserver) -> this.invokeSharedMethod((String)method.getKey(), ObjectContext.fromSyscalls((Syscalls)Syscalls.current()), (InvokeRequest)invokeRequest, (StreamObserver<Value>)streamObserver));
            serverServiceDefinitionBuilder.addMethod(desc, handler);
        }
        return serverServiceDefinitionBuilder.build();
    }
}

