/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.workflow.impl;

import com.google.protobuf.Empty;
import dev.restate.sdk.Awaitable;
import dev.restate.sdk.Awakeable;
import dev.restate.sdk.AwakeableHandle;
import dev.restate.sdk.ObjectContext;
import dev.restate.sdk.RestateRandom;
import dev.restate.sdk.common.Serde;
import dev.restate.sdk.common.StateKey;
import dev.restate.sdk.common.Target;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.common.function.ThrowingRunnable;
import dev.restate.sdk.common.function.ThrowingSupplier;
import dev.restate.sdk.workflow.DurablePromise;
import dev.restate.sdk.workflow.DurablePromiseHandle;
import dev.restate.sdk.workflow.DurablePromiseKey;
import dev.restate.sdk.workflow.WorkflowContext;
import dev.restate.sdk.workflow.generated.CompleteDurablePromiseRequest;
import dev.restate.sdk.workflow.generated.GetDurablePromiseCompletionRequest;
import dev.restate.sdk.workflow.generated.GetStateResponse;
import dev.restate.sdk.workflow.generated.MaybeDurablePromiseCompletion;
import dev.restate.sdk.workflow.generated.SetStateRequest;
import dev.restate.sdk.workflow.generated.StateRequest;
import dev.restate.sdk.workflow.generated.WaitDurablePromiseCompletionRequest;
import dev.restate.sdk.workflow.impl.DurablePromiseHandleImpl;
import dev.restate.sdk.workflow.impl.DurablePromiseImpl;
import dev.restate.sdk.workflow.impl.WorkflowCodegenUtil;
import dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nonnull;

class WorkflowContextImpl
implements WorkflowContext {
    private final ObjectContext ctx;
    private final String workflowKey;
    private final boolean isExclusive;
    private final MethodDescriptor<StateRequest, GetStateResponse> workflowManagerGetState;
    private final MethodDescriptor<SetStateRequest, Empty> workflowManagerSetState;
    private final MethodDescriptor<StateRequest, Empty> workflowManagerClearState;
    private final MethodDescriptor<WaitDurablePromiseCompletionRequest, Empty> workflowManagerWaitDurablePromiseCompletion;
    private final MethodDescriptor<GetDurablePromiseCompletionRequest, MaybeDurablePromiseCompletion> workflowManagerGetDurablePromiseCompletion;
    private final MethodDescriptor<CompleteDurablePromiseRequest, Empty> workflowManagerCompleteSignal;

    WorkflowContextImpl(String workflowFqsn, ObjectContext ctx, String workflowKey, boolean isExclusive) {
        this.ctx = ctx;
        this.workflowKey = workflowKey;
        this.isExclusive = isExclusive;
        this.workflowManagerGetState = WorkflowCodegenUtil.generateMethodDescriptorForWorkflowManager(WorkflowManagerGrpc.getGetStateMethod(), workflowFqsn);
        this.workflowManagerSetState = WorkflowCodegenUtil.generateMethodDescriptorForWorkflowManager(WorkflowManagerGrpc.getSetStateMethod(), workflowFqsn);
        this.workflowManagerClearState = WorkflowCodegenUtil.generateMethodDescriptorForWorkflowManager(WorkflowManagerGrpc.getClearStateMethod(), workflowFqsn);
        this.workflowManagerWaitDurablePromiseCompletion = WorkflowCodegenUtil.generateMethodDescriptorForWorkflowManager(WorkflowManagerGrpc.getWaitDurablePromiseCompletionMethod(), workflowFqsn);
        this.workflowManagerGetDurablePromiseCompletion = WorkflowCodegenUtil.generateMethodDescriptorForWorkflowManager(WorkflowManagerGrpc.getGetDurablePromiseCompletionMethod(), workflowFqsn);
        this.workflowManagerCompleteSignal = WorkflowCodegenUtil.generateMethodDescriptorForWorkflowManager(WorkflowManagerGrpc.getCompleteDurablePromiseMethod(), workflowFqsn);
    }

    @Override
    public String workflowKey() {
        return this.workflowKey;
    }

    @Override
    public <T> Optional<T> get(StateKey<T> key) {
        GetStateResponse response = (GetStateResponse)this.ctx.call(this.workflowManagerGetState, (Object)StateRequest.newBuilder().setKey(this.workflowKey).setStateKey(key.name()).build()).await();
        switch (response.getResultCase()) {
            case VALUE: {
                return Optional.of(key.serde().deserialize(response.getValue()));
            }
            case EMPTY: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unexpected response from WorkflowManager");
    }

    @Override
    public void clear(StateKey<?> key) {
        if (!this.isExclusive) {
            throw new UnsupportedOperationException("Can't perform a state update on a SharedContext");
        }
        this.ctx.oneWayCall(this.workflowManagerClearState, (Object)StateRequest.newBuilder().setKey(this.workflowKey).setStateKey(key.name()).build());
    }

    @Override
    public <T> void set(StateKey<T> key, @Nonnull T value) {
        if (!this.isExclusive) {
            throw new UnsupportedOperationException("Can't perform a state update on a SharedContext");
        }
        this.ctx.oneWayCall(this.workflowManagerSetState, (Object)SetStateRequest.newBuilder().setKey(this.workflowKey).setStateKey(key.name()).setStateValue(key.serde().serializeToByteString(value)).build());
    }

    @Override
    public <T> DurablePromise<T> durablePromise(DurablePromiseKey<T> key) {
        return DurablePromiseImpl.prepare(this.workflowKey, this.ctx, key, this.workflowManagerWaitDurablePromiseCompletion, this.workflowManagerGetDurablePromiseCompletion);
    }

    @Override
    public <T> DurablePromiseHandle<T> durablePromiseHandle(DurablePromiseKey<T> key) {
        return new DurablePromiseHandleImpl<T>(this.workflowKey, this.ctx, this.workflowManagerCompleteSignal, key);
    }

    public void sleep(Duration duration) {
        this.ctx.sleep(duration);
    }

    public Awaitable<Void> timer(Duration duration) {
        return this.ctx.timer(duration);
    }

    public <T, R> Awaitable<R> call(MethodDescriptor<T, R> methodDescriptor, T parameter) {
        return this.ctx.call(methodDescriptor, parameter);
    }

    public <T, R> Awaitable<R> call(Target target, Serde<T> inputSerde, Serde<R> outputSerde, T parameter) {
        return this.ctx.call(target, inputSerde, outputSerde, parameter);
    }

    public <T> void oneWayCall(Target target, Serde<T> inputSerde, T parameter) {
        this.ctx.oneWayCall(target, inputSerde, parameter);
    }

    public <T> void oneWayCall(MethodDescriptor<T, ?> methodDescriptor, T parameter) {
        this.ctx.oneWayCall(methodDescriptor, parameter);
    }

    public <T> void delayedCall(Target target, Serde<T> inputSerde, T parameter, Duration delay) {
        this.ctx.delayedCall(target, inputSerde, parameter, delay);
    }

    public <T> void delayedCall(MethodDescriptor<T, ?> methodDescriptor, T parameter, Duration delay) {
        this.ctx.delayedCall(methodDescriptor, parameter, delay);
    }

    public <T> T sideEffect(Serde<T> serde, ThrowingSupplier<T> action) throws TerminalException {
        return (T)this.ctx.sideEffect(serde, action);
    }

    public void sideEffect(ThrowingRunnable runnable) throws TerminalException {
        this.ctx.sideEffect(runnable);
    }

    public <T> Awakeable<T> awakeable(Serde<T> serde) {
        return this.ctx.awakeable(serde);
    }

    public AwakeableHandle awakeableHandle(String id) {
        return this.ctx.awakeableHandle(id);
    }

    public RestateRandom random() {
        return this.ctx.random();
    }
}

