/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.workflow.impl;

import com.google.protobuf.Empty;
import com.google.protobuf.Value;
import dev.restate.generated.IngressGrpc;
import dev.restate.generated.InvokeRequest;
import dev.restate.sdk.Awaitable;
import dev.restate.sdk.Context;
import dev.restate.sdk.common.Serde;
import dev.restate.sdk.common.StateKey;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.dynrpc.CodegenUtils;
import dev.restate.sdk.workflow.generated.GetOutputResponse;
import dev.restate.sdk.workflow.generated.GetStateResponse;
import dev.restate.sdk.workflow.generated.InvokeRequest;
import dev.restate.sdk.workflow.generated.OutputRequest;
import dev.restate.sdk.workflow.generated.StateRequest;
import dev.restate.sdk.workflow.generated.SubmitResponse;
import dev.restate.sdk.workflow.generated.WorkflowExecutionState;
import dev.restate.sdk.workflow.template.generated.WorkflowGrpc;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class WorkflowCodegenUtil {
    private WorkflowCodegenUtil() {
    }

    public static <Req, Res> MethodDescriptor<Req, Res> generateMethodDescriptorForWorkflowManager(MethodDescriptor<Req, Res> original, String workflowFqsn) {
        String workflowServiceFqsn = workflowFqsn + "InternalManager";
        return original.toBuilder().setFullMethodName(MethodDescriptor.generateFullMethodName((String)workflowServiceFqsn, (String)Objects.requireNonNull(original.getBareMethodName()))).build();
    }

    public static <Req, Res> MethodDescriptor<Req, Res> generateMethodDescriptorForWorkflow(MethodDescriptor<Req, Res> original, String workflowFqsn, String methodName) {
        return original.toBuilder().setFullMethodName(MethodDescriptor.generateFullMethodName((String)workflowFqsn, (String)methodName)).build();
    }

    public static MethodDescriptor<dev.restate.sdk.workflow.generated.InvokeRequest, SubmitResponse> generateMethodDescriptorForWorkflowSubmit(String workflowFqsn) {
        return WorkflowGrpc.getSubmitMethod().toBuilder().setFullMethodName(MethodDescriptor.generateFullMethodName((String)workflowFqsn, (String)WorkflowGrpc.getSubmitMethod().getBareMethodName())).build();
    }

    public static MethodDescriptor<dev.restate.sdk.workflow.generated.InvokeRequest, Empty> generateMethodDescriptorForWorkflowInternalStart(String workflowFqsn) {
        return WorkflowGrpc.getInternalStartMethod().toBuilder().setFullMethodName(MethodDescriptor.generateFullMethodName((String)workflowFqsn, (String)WorkflowGrpc.getInternalStartMethod().getBareMethodName())).build();
    }

    public static class ExternalClient {
        private ExternalClient() {
        }

        public static WorkflowExecutionState submit(Channel channel, MethodDescriptor<dev.restate.sdk.workflow.generated.InvokeRequest, SubmitResponse> submitMethodDesc, String workflowKey, @Nullable Value payload) {
            InvokeRequest.Builder reqBuilder = dev.restate.sdk.workflow.generated.InvokeRequest.newBuilder().setKey(workflowKey);
            if (payload != null) {
                reqBuilder.setPayload(payload);
            }
            return ((SubmitResponse)ClientCalls.blockingUnaryCall((Channel)channel, submitMethodDesc, (CallOptions)CallOptions.DEFAULT, (Object)reqBuilder.build())).getState();
        }

        public static <T> Optional<T> getOutput(Channel channel, MethodDescriptor<OutputRequest, GetOutputResponse> getOutputMethodDesc, String workflowKey, Serde<T> serde) {
            GetOutputResponse response = (GetOutputResponse)ClientCalls.blockingUnaryCall((Channel)channel, getOutputMethodDesc, (CallOptions)CallOptions.DEFAULT, (Object)OutputRequest.newBuilder().setKey(workflowKey).build());
            if (response.hasNotCompleted()) {
                return Optional.empty();
            }
            if (response.hasFailure()) {
                throw new TerminalException(TerminalException.Code.fromValue((int)response.getFailure().getCode()), response.getFailure().getMessage());
            }
            return Optional.ofNullable(CodegenUtils.valueToT(serde, (Value)response.getValue()));
        }

        public static boolean isCompleted(Channel channel, MethodDescriptor<OutputRequest, GetOutputResponse> getOutputMethodDesc, String workflowKey) {
            GetOutputResponse response = (GetOutputResponse)ClientCalls.blockingUnaryCall((Channel)channel, getOutputMethodDesc, (CallOptions)CallOptions.DEFAULT, (Object)OutputRequest.newBuilder().setKey(workflowKey).build());
            if (response.hasFailure()) {
                throw new TerminalException(TerminalException.Code.fromValue((int)response.getFailure().getCode()), response.getFailure().getMessage());
            }
            return !response.hasNotCompleted();
        }

        public static Value invokeShared(Channel channel, MethodDescriptor<dev.restate.sdk.workflow.generated.InvokeRequest, Value> invokeMethodDesc, String workflowKey, @Nullable Value payload) {
            InvokeRequest.Builder reqBuilder = dev.restate.sdk.workflow.generated.InvokeRequest.newBuilder().setKey(workflowKey);
            if (payload != null) {
                reqBuilder.setPayload(payload);
            }
            return (Value)ClientCalls.blockingUnaryCall((Channel)channel, invokeMethodDesc, (CallOptions)CallOptions.DEFAULT, (Object)reqBuilder.build());
        }

        public static void invokeSharedOneWay(Channel channel, MethodDescriptor<dev.restate.sdk.workflow.generated.InvokeRequest, Value> invokeMethodDesc, String workflowKey, @Nullable Value payload) {
            InvokeRequest.Builder reqBuilder = dev.restate.sdk.workflow.generated.InvokeRequest.newBuilder().setKey(workflowKey);
            if (payload != null) {
                reqBuilder.setPayload(payload);
            }
            IngressGrpc.IngressBlockingStub ingressClient = IngressGrpc.newBlockingStub(channel);
            ingressClient.invoke(InvokeRequest.newBuilder().setService(invokeMethodDesc.getServiceName()).setMethod(invokeMethodDesc.getBareMethodName()).setPb(reqBuilder.build().toByteString()).build());
        }

        public static <T> Optional<T> getState(Channel channel, MethodDescriptor<StateRequest, GetStateResponse> getStateMethodDesc, String workflowKey, StateKey<T> key) {
            GetStateResponse response = (GetStateResponse)ClientCalls.blockingUnaryCall((Channel)channel, getStateMethodDesc, (CallOptions)CallOptions.DEFAULT, (Object)StateRequest.newBuilder().setStateKey(key.name()).setKey(workflowKey).build());
            if (response.hasEmpty()) {
                return Optional.empty();
            }
            return Optional.of(key.serde().deserialize(response.getValue()));
        }
    }

    public static class RestateClient {
        private RestateClient() {
        }

        public static Awaitable<WorkflowExecutionState> submit(Context ctx, MethodDescriptor<dev.restate.sdk.workflow.generated.InvokeRequest, SubmitResponse> submitMethodDesc, String workflowKey, @Nullable Value payload) {
            InvokeRequest.Builder reqBuilder = dev.restate.sdk.workflow.generated.InvokeRequest.newBuilder().setKey(workflowKey);
            if (payload != null) {
                reqBuilder.setPayload(payload);
            }
            return ctx.call(submitMethodDesc, (Object)reqBuilder.build()).map(SubmitResponse::getState);
        }

        public static <T> Awaitable<Optional<T>> getOutput(Context ctx, MethodDescriptor<OutputRequest, GetOutputResponse> getOutputMethodDesc, String workflowKey, Serde<T> serde) {
            return ctx.call(getOutputMethodDesc, (Object)OutputRequest.newBuilder().setKey(workflowKey).build()).map(response -> {
                if (response.hasNotCompleted()) {
                    return Optional.empty();
                }
                if (response.hasFailure()) {
                    throw new TerminalException(TerminalException.Code.fromValue((int)response.getFailure().getCode()), response.getFailure().getMessage());
                }
                return Optional.ofNullable(CodegenUtils.valueToT((Serde)serde, (Value)response.getValue()));
            });
        }

        public static Awaitable<Boolean> isCompleted(Context ctx, MethodDescriptor<OutputRequest, GetOutputResponse> getOutputMethodDesc, String workflowKey) {
            return ctx.call(getOutputMethodDesc, (Object)OutputRequest.newBuilder().setKey(workflowKey).build()).map(response -> {
                if (response.hasFailure()) {
                    throw new TerminalException(TerminalException.Code.fromValue((int)response.getFailure().getCode()), response.getFailure().getMessage());
                }
                return !response.hasNotCompleted();
            });
        }

        public static Awaitable<Value> invokeShared(Context ctx, MethodDescriptor<dev.restate.sdk.workflow.generated.InvokeRequest, Value> invokeMethodDesc, String workflowKey, @Nullable Value payload) {
            InvokeRequest.Builder reqBuilder = dev.restate.sdk.workflow.generated.InvokeRequest.newBuilder().setKey(workflowKey);
            if (payload != null) {
                reqBuilder.setPayload(payload);
            }
            return ctx.call(invokeMethodDesc, (Object)reqBuilder.build());
        }

        public static void invokeSharedOneWay(Context ctx, MethodDescriptor<dev.restate.sdk.workflow.generated.InvokeRequest, Value> invokeMethodDesc, String workflowKey, @Nullable Value payload) {
            InvokeRequest.Builder reqBuilder = dev.restate.sdk.workflow.generated.InvokeRequest.newBuilder().setKey(workflowKey);
            if (payload != null) {
                reqBuilder.setPayload(payload);
            }
            ctx.oneWayCall(invokeMethodDesc, (Object)reqBuilder.build());
        }

        public static void invokeSharedDelayed(Context ctx, MethodDescriptor<dev.restate.sdk.workflow.generated.InvokeRequest, Value> invokeMethodDesc, String workflowKey, @Nullable Value payload, Duration delay) {
            InvokeRequest.Builder reqBuilder = dev.restate.sdk.workflow.generated.InvokeRequest.newBuilder().setKey(workflowKey);
            if (payload != null) {
                reqBuilder.setPayload(payload);
            }
            ctx.delayedCall(invokeMethodDesc, (Object)reqBuilder.build(), delay);
        }

        public static <T> Awaitable<Optional<T>> getState(Context ctx, MethodDescriptor<StateRequest, GetStateResponse> getStateMethodDesc, String workflowKey, StateKey<T> key) {
            return ctx.call(getStateMethodDesc, (Object)StateRequest.newBuilder().setStateKey(key.name()).setKey(workflowKey).build()).map(response -> {
                if (response.hasEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(key.serde().deserialize(response.getValue()));
            });
        }
    }
}

