/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.workflow.impl;

import com.google.protobuf.Empty;
import dev.restate.sdk.Awaitable;
import dev.restate.sdk.Awakeable;
import dev.restate.sdk.ObjectContext;
import dev.restate.sdk.common.TerminalException;
import dev.restate.sdk.workflow.DurablePromise;
import dev.restate.sdk.workflow.DurablePromiseKey;
import dev.restate.sdk.workflow.generated.GetDurablePromiseCompletionRequest;
import dev.restate.sdk.workflow.generated.MaybeDurablePromiseCompletion;
import dev.restate.sdk.workflow.generated.WaitDurablePromiseCompletionRequest;
import io.grpc.MethodDescriptor;
import java.util.Optional;

public final class DurablePromiseImpl<T>
implements DurablePromise<T> {
    private final String workflowKey;
    private final ObjectContext ctx;
    private final DurablePromiseKey<T> key;
    private final Awaitable<T> awakeable;
    private final MethodDescriptor<GetDurablePromiseCompletionRequest, MaybeDurablePromiseCompletion> workflowManagerGetDurablePromiseCompletion;

    private DurablePromiseImpl(String workflowKey, ObjectContext ctx, DurablePromiseKey<T> key, Awaitable<T> awakeable, MethodDescriptor<GetDurablePromiseCompletionRequest, MaybeDurablePromiseCompletion> workflowManagerGetDurablePromiseCompletion) {
        this.workflowKey = workflowKey;
        this.ctx = ctx;
        this.key = key;
        this.awakeable = awakeable;
        this.workflowManagerGetDurablePromiseCompletion = workflowManagerGetDurablePromiseCompletion;
    }

    @Override
    public Awaitable<T> awaitable() {
        return this.awakeable;
    }

    @Override
    public Optional<T> peek() {
        MaybeDurablePromiseCompletion maybeDurablePromiseCompletion = (MaybeDurablePromiseCompletion)this.ctx.call(this.workflowManagerGetDurablePromiseCompletion, (Object)GetDurablePromiseCompletionRequest.newBuilder().setKey(this.workflowKey).setDurablePromiseKey(this.key.name()).build()).await();
        switch (maybeDurablePromiseCompletion.getResultCase()) {
            case VALUE: {
                return Optional.of(this.key.serde().deserialize(maybeDurablePromiseCompletion.getValue()));
            }
            case FAILURE: {
                throw new TerminalException(TerminalException.Code.fromValue((int)maybeDurablePromiseCompletion.getFailure().getCode()), maybeDurablePromiseCompletion.getFailure().getMessage());
            }
            case NOT_COMPLETED: {
                return Optional.empty();
            }
        }
        throw new IllegalStateException("Unexpected response from WorkflowManager");
    }

    @Override
    public boolean isCompleted() {
        MaybeDurablePromiseCompletion maybeDurablePromiseCompletion = (MaybeDurablePromiseCompletion)this.ctx.call(this.workflowManagerGetDurablePromiseCompletion, (Object)GetDurablePromiseCompletionRequest.newBuilder().setKey(this.workflowKey).setDurablePromiseKey(this.key.name()).build()).await();
        return !maybeDurablePromiseCompletion.hasNotCompleted();
    }

    static <T> DurablePromise<T> prepare(String workflowKey, ObjectContext ctx, DurablePromiseKey<T> key, MethodDescriptor<WaitDurablePromiseCompletionRequest, Empty> workflowManagerWaitDurablePromiseCompletion, MethodDescriptor<GetDurablePromiseCompletionRequest, MaybeDurablePromiseCompletion> workflowManagerGetDurablePromiseCompletion) {
        Awakeable awakeable = ctx.awakeable(key.serde());
        ctx.oneWayCall(workflowManagerWaitDurablePromiseCompletion, (Object)WaitDurablePromiseCompletionRequest.newBuilder().setKey(workflowKey).setDurablePromiseKey(key.name()).setAwakeableId(awakeable.id()).build());
        return new DurablePromiseImpl<T>(workflowKey, ctx, key, awakeable, workflowManagerGetDurablePromiseCompletion);
    }
}

