/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.workflow;

import dev.restate.sdk.common.CoreSerdes;
import dev.restate.sdk.common.Serde;

public final class DurablePromiseKey<T> {
    private final String name;
    private final Serde<T> serde;

    private DurablePromiseKey(String name, Serde<T> serde) {
        this.name = name;
        this.serde = serde;
    }

    public static <T> DurablePromiseKey<T> of(String name, Serde<T> serde) {
        return new DurablePromiseKey<T>(name, serde);
    }

    public static DurablePromiseKey<String> string(String name) {
        return new DurablePromiseKey<String>(name, CoreSerdes.JSON_STRING);
    }

    public static DurablePromiseKey<byte[]> raw(String name) {
        return new DurablePromiseKey<byte[]>(name, CoreSerdes.RAW);
    }

    public String name() {
        return this.name;
    }

    public Serde<T> serde() {
        return this.serde;
    }
}

