package dev.restate.sdk.workflow.template.generated;

import dev.restate.sdk.Context;
import dev.restate.sdk.ObjectContext;
import dev.restate.sdk.Awaitable;
import dev.restate.sdk.common.syscalls.Syscalls;
import java.time.Duration;
import static dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getServiceDescriptor;

public class WorkflowRestate {
    private WorkflowRestate() {}

    /**
     * Create a new client from the given {@link ObjectContext}.
     */
    public static WorkflowRestateClient newClient(Context ctx) {
        return new WorkflowRestateClient(ctx);
    }

    /**
     * <pre>
     * 
     * </pre>
     */
    public static final class WorkflowRestateClient {
        private final Context ctx;

        WorkflowRestateClient(Context ctx) {
            this.ctx = ctx;
        }

        // Create a variant of this client to execute oneWay calls.
        public WorkflowRestateOneWayClient oneWay() {
            return new WorkflowRestateOneWayClient(ctx);
        }

        // Create a variant of this client to execute delayed calls.
        public WorkflowRestateDelayedClient delayed(Duration delay) {
            return new WorkflowRestateDelayedClient(ctx, delay);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public Awaitable<dev.restate.sdk.workflow.generated.SubmitResponse> submit(dev.restate.sdk.workflow.generated.InvokeRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getSubmitMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public Awaitable<com.google.protobuf.Empty> internalStart(dev.restate.sdk.workflow.generated.InvokeRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getInternalStartMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public Awaitable<com.google.protobuf.Value> invokeTemplate(dev.restate.sdk.workflow.generated.InvokeRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getInvokeTemplateMethod(), request);
        }

    }

    public static final class WorkflowRestateOneWayClient {
        private final Context ctx;

        WorkflowRestateOneWayClient(Context ctx) {
            this.ctx = ctx;
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void submit(dev.restate.sdk.workflow.generated.InvokeRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getSubmitMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void internalStart(dev.restate.sdk.workflow.generated.InvokeRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getInternalStartMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void invokeTemplate(dev.restate.sdk.workflow.generated.InvokeRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getInvokeTemplateMethod(), request);
        }

    }

    public static final class WorkflowRestateDelayedClient {
        private final Context ctx;
        private final Duration delay;

        WorkflowRestateDelayedClient(Context ctx, Duration delay) {
            this.ctx = ctx;
            this.delay = delay;
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void submit(dev.restate.sdk.workflow.generated.InvokeRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getSubmitMethod(), request, this.delay);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void internalStart(dev.restate.sdk.workflow.generated.InvokeRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getInternalStartMethod(), request, this.delay);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void invokeTemplate(dev.restate.sdk.workflow.generated.InvokeRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getInvokeTemplateMethod(), request, this.delay);
        }

    }

    /**
     * <pre>
     * 
     * </pre>
     */
    public static abstract class WorkflowRestateImplBase implements dev.restate.sdk.Component {

        /**
         * <pre>
         * 
         * </pre>
         */
        public dev.restate.sdk.workflow.generated.SubmitResponse submit(Context context, dev.restate.sdk.workflow.generated.InvokeRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * 
         * </pre>
         */
        public void internalStart(Context context, dev.restate.sdk.workflow.generated.InvokeRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * 
         * </pre>
         */
        public com.google.protobuf.Value invokeTemplate(Context context, dev.restate.sdk.workflow.generated.InvokeRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getSubmitMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::submit)))
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getInternalStartMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::internalStart)))
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowGrpc.getInvokeTemplateMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::invokeTemplate)))
                    .build();
        }
    }

    private static final class HandlerAdapter<Req, Resp> implements
        io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp> {

        private final java.util.function.BiFunction<ObjectContext, Req, Resp> handler;

        private HandlerAdapter(java.util.function.BiFunction<ObjectContext, Req, Resp> handler) {
            this.handler = handler;
        }

        @Override
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            responseObserver.onNext(handler.apply(ObjectContext.fromSyscalls(Syscalls.current()), request));
            responseObserver.onCompleted();
        }

        private static <Req, Resp> HandlerAdapter<Req, Resp> of(java.util.function.BiFunction<ObjectContext, Req, Resp> handler) {
            return new HandlerAdapter<>(handler);
        }

        private static <Resp> HandlerAdapter<com.google.protobuf.Empty, Resp> of(java.util.function.Function<ObjectContext, Resp> handler) {
            return new HandlerAdapter<>((ctx, e) -> handler.apply(ctx));
        }

        private static <Req> HandlerAdapter<Req, com.google.protobuf.Empty> of(java.util.function.BiConsumer<ObjectContext, Req> handler) {
            return new HandlerAdapter<>((ctx, req) -> {
                handler.accept(ctx, req);
                return com.google.protobuf.Empty.getDefaultInstance();
            });
        }

        private static HandlerAdapter<com.google.protobuf.Empty, com.google.protobuf.Empty> of(java.util.function.Consumer<ObjectContext> handler) {
            return new HandlerAdapter<>((ctx, req) -> {
                handler.accept(ctx);
                return com.google.protobuf.Empty.getDefaultInstance();
            });
        }
    }

}