package dev.restate.sdk.workflow.template.generated;

import dev.restate.sdk.Context;
import dev.restate.sdk.ObjectContext;
import dev.restate.sdk.Awaitable;
import dev.restate.sdk.common.syscalls.Syscalls;
import java.time.Duration;
import static dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getServiceDescriptor;

public class WorkflowManagerRestate {
    private WorkflowManagerRestate() {}

    /**
     * Create a new client from the given {@link ObjectContext}.
     */
    public static WorkflowManagerRestateClient newClient(Context ctx) {
        return new WorkflowManagerRestateClient(ctx);
    }

    /**
     * <pre>
     * 
     * </pre>
     */
    public static final class WorkflowManagerRestateClient {
        private final Context ctx;

        WorkflowManagerRestateClient(Context ctx) {
            this.ctx = ctx;
        }

        // Create a variant of this client to execute oneWay calls.
        public WorkflowManagerRestateOneWayClient oneWay() {
            return new WorkflowManagerRestateOneWayClient(ctx);
        }

        // Create a variant of this client to execute delayed calls.
        public WorkflowManagerRestateDelayedClient delayed(Duration delay) {
            return new WorkflowManagerRestateDelayedClient(ctx, delay);
        }

        
        /**
         * <pre>
         *  State
         * </pre>
         */
        public Awaitable<dev.restate.sdk.workflow.generated.GetStateResponse> getState(dev.restate.sdk.workflow.generated.StateRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getGetStateMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public Awaitable<com.google.protobuf.Empty> setState(dev.restate.sdk.workflow.generated.SetStateRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getSetStateMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public Awaitable<com.google.protobuf.Empty> clearState(dev.restate.sdk.workflow.generated.StateRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getClearStateMethod(), request);
        }

        
        /**
         * <pre>
         *  Start and output
         * </pre>
         */
        public Awaitable<dev.restate.sdk.workflow.generated.StartResponse> tryStart(dev.restate.sdk.workflow.generated.StartRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getTryStartMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public Awaitable<dev.restate.sdk.workflow.generated.GetOutputResponse> getOutput(dev.restate.sdk.workflow.generated.OutputRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getGetOutputMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public Awaitable<com.google.protobuf.Empty> setOutput(dev.restate.sdk.workflow.generated.SetOutputRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getSetOutputMethod(), request);
        }

        
        /**
         * <pre>
         *  Durable promises
         * </pre>
         */
        public Awaitable<com.google.protobuf.Empty> waitDurablePromiseCompletion(dev.restate.sdk.workflow.generated.WaitDurablePromiseCompletionRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getWaitDurablePromiseCompletionMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public Awaitable<dev.restate.sdk.workflow.generated.MaybeDurablePromiseCompletion> getDurablePromiseCompletion(dev.restate.sdk.workflow.generated.GetDurablePromiseCompletionRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getGetDurablePromiseCompletionMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public Awaitable<com.google.protobuf.Empty> completeDurablePromise(dev.restate.sdk.workflow.generated.CompleteDurablePromiseRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getCompleteDurablePromiseMethod(), request);
        }

        
        /**
         * <pre>
         *  Others
         * </pre>
         */
        public Awaitable<com.google.protobuf.Empty> cleanup(dev.restate.sdk.workflow.generated.WorkflowManagerRequest request) {
            return this.ctx.call(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getCleanupMethod(), request);
        }

    }

    public static final class WorkflowManagerRestateOneWayClient {
        private final Context ctx;

        WorkflowManagerRestateOneWayClient(Context ctx) {
            this.ctx = ctx;
        }

        
        /**
         * <pre>
         *  State
         * </pre>
         */
        public void getState(dev.restate.sdk.workflow.generated.StateRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getGetStateMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void setState(dev.restate.sdk.workflow.generated.SetStateRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getSetStateMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void clearState(dev.restate.sdk.workflow.generated.StateRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getClearStateMethod(), request);
        }

        
        /**
         * <pre>
         *  Start and output
         * </pre>
         */
        public void tryStart(dev.restate.sdk.workflow.generated.StartRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getTryStartMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void getOutput(dev.restate.sdk.workflow.generated.OutputRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getGetOutputMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void setOutput(dev.restate.sdk.workflow.generated.SetOutputRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getSetOutputMethod(), request);
        }

        
        /**
         * <pre>
         *  Durable promises
         * </pre>
         */
        public void waitDurablePromiseCompletion(dev.restate.sdk.workflow.generated.WaitDurablePromiseCompletionRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getWaitDurablePromiseCompletionMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void getDurablePromiseCompletion(dev.restate.sdk.workflow.generated.GetDurablePromiseCompletionRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getGetDurablePromiseCompletionMethod(), request);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void completeDurablePromise(dev.restate.sdk.workflow.generated.CompleteDurablePromiseRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getCompleteDurablePromiseMethod(), request);
        }

        
        /**
         * <pre>
         *  Others
         * </pre>
         */
        public void cleanup(dev.restate.sdk.workflow.generated.WorkflowManagerRequest request) {
            this.ctx.oneWayCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getCleanupMethod(), request);
        }

    }

    public static final class WorkflowManagerRestateDelayedClient {
        private final Context ctx;
        private final Duration delay;

        WorkflowManagerRestateDelayedClient(Context ctx, Duration delay) {
            this.ctx = ctx;
            this.delay = delay;
        }

        
        /**
         * <pre>
         *  State
         * </pre>
         */
        public void getState(dev.restate.sdk.workflow.generated.StateRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getGetStateMethod(), request, this.delay);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void setState(dev.restate.sdk.workflow.generated.SetStateRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getSetStateMethod(), request, this.delay);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void clearState(dev.restate.sdk.workflow.generated.StateRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getClearStateMethod(), request, this.delay);
        }

        
        /**
         * <pre>
         *  Start and output
         * </pre>
         */
        public void tryStart(dev.restate.sdk.workflow.generated.StartRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getTryStartMethod(), request, this.delay);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void getOutput(dev.restate.sdk.workflow.generated.OutputRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getGetOutputMethod(), request, this.delay);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void setOutput(dev.restate.sdk.workflow.generated.SetOutputRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getSetOutputMethod(), request, this.delay);
        }

        
        /**
         * <pre>
         *  Durable promises
         * </pre>
         */
        public void waitDurablePromiseCompletion(dev.restate.sdk.workflow.generated.WaitDurablePromiseCompletionRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getWaitDurablePromiseCompletionMethod(), request, this.delay);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void getDurablePromiseCompletion(dev.restate.sdk.workflow.generated.GetDurablePromiseCompletionRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getGetDurablePromiseCompletionMethod(), request, this.delay);
        }

        
        /**
         * <pre>
         * 
         * </pre>
         */
        public void completeDurablePromise(dev.restate.sdk.workflow.generated.CompleteDurablePromiseRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getCompleteDurablePromiseMethod(), request, this.delay);
        }

        
        /**
         * <pre>
         *  Others
         * </pre>
         */
        public void cleanup(dev.restate.sdk.workflow.generated.WorkflowManagerRequest request) {
            this.ctx.delayedCall(dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getCleanupMethod(), request, this.delay);
        }

    }

    /**
     * <pre>
     * 
     * </pre>
     */
    public static abstract class WorkflowManagerRestateImplBase implements dev.restate.sdk.Component {

        /**
         * <pre>
         *  State
         * </pre>
         */
        public dev.restate.sdk.workflow.generated.GetStateResponse getState(ObjectContext context, dev.restate.sdk.workflow.generated.StateRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * 
         * </pre>
         */
        public void setState(ObjectContext context, dev.restate.sdk.workflow.generated.SetStateRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * 
         * </pre>
         */
        public void clearState(ObjectContext context, dev.restate.sdk.workflow.generated.StateRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Start and output
         * </pre>
         */
        public dev.restate.sdk.workflow.generated.StartResponse tryStart(ObjectContext context, dev.restate.sdk.workflow.generated.StartRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * 
         * </pre>
         */
        public dev.restate.sdk.workflow.generated.GetOutputResponse getOutput(ObjectContext context, dev.restate.sdk.workflow.generated.OutputRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * 
         * </pre>
         */
        public void setOutput(ObjectContext context, dev.restate.sdk.workflow.generated.SetOutputRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Durable promises
         * </pre>
         */
        public void waitDurablePromiseCompletion(ObjectContext context, dev.restate.sdk.workflow.generated.WaitDurablePromiseCompletionRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * 
         * </pre>
         */
        public dev.restate.sdk.workflow.generated.MaybeDurablePromiseCompletion getDurablePromiseCompletion(ObjectContext context, dev.restate.sdk.workflow.generated.GetDurablePromiseCompletionRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        /**
         * <pre>
         * 
         * </pre>
         */
        public void completeDurablePromise(ObjectContext context, dev.restate.sdk.workflow.generated.CompleteDurablePromiseRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Others
         * </pre>
         */
        public void cleanup(ObjectContext context, dev.restate.sdk.workflow.generated.WorkflowManagerRequest request) throws dev.restate.sdk.common.TerminalException {
            throw new dev.restate.sdk.common.TerminalException(dev.restate.sdk.common.TerminalException.Code.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getGetStateMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::getState)))
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getSetStateMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::setState)))
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getClearStateMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::clearState)))
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getTryStartMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::tryStart)))
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getGetOutputMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::getOutput)))
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getSetOutputMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::setOutput)))
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getWaitDurablePromiseCompletionMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::waitDurablePromiseCompletion)))
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getGetDurablePromiseCompletionMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::getDurablePromiseCompletion)))
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getCompleteDurablePromiseMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::completeDurablePromise)))
                    .addMethod(
                            dev.restate.sdk.workflow.template.generated.WorkflowManagerGrpc.getCleanupMethod(),
                            io.grpc.stub.ServerCalls.asyncUnaryCall(
                                    HandlerAdapter.of(this::cleanup)))
                    .build();
        }
    }

    private static final class HandlerAdapter<Req, Resp> implements
        io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp> {

        private final java.util.function.BiFunction<ObjectContext, Req, Resp> handler;

        private HandlerAdapter(java.util.function.BiFunction<ObjectContext, Req, Resp> handler) {
            this.handler = handler;
        }

        @Override
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            responseObserver.onNext(handler.apply(ObjectContext.fromSyscalls(Syscalls.current()), request));
            responseObserver.onCompleted();
        }

        private static <Req, Resp> HandlerAdapter<Req, Resp> of(java.util.function.BiFunction<ObjectContext, Req, Resp> handler) {
            return new HandlerAdapter<>(handler);
        }

        private static <Resp> HandlerAdapter<com.google.protobuf.Empty, Resp> of(java.util.function.Function<ObjectContext, Resp> handler) {
            return new HandlerAdapter<>((ctx, e) -> handler.apply(ctx));
        }

        private static <Req> HandlerAdapter<Req, com.google.protobuf.Empty> of(java.util.function.BiConsumer<ObjectContext, Req> handler) {
            return new HandlerAdapter<>((ctx, req) -> {
                handler.accept(ctx, req);
                return com.google.protobuf.Empty.getDefaultInstance();
            });
        }

        private static HandlerAdapter<com.google.protobuf.Empty, com.google.protobuf.Empty> of(java.util.function.Consumer<ObjectContext> handler) {
            return new HandlerAdapter<>((ctx, req) -> {
                handler.accept(ctx);
                return com.google.protobuf.Empty.getDefaultInstance();
            });
        }
    }

}