/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.testing;

import dev.restate.sdk.common.syscalls.ServiceDefinition;
import dev.restate.sdk.http.vertx.RestateHttpEndpointBuilder;
import dev.restate.sdk.testing.ManualRestateRunner;
import dev.restate.sdk.testing.RestateRunner;
import java.util.HashMap;
import java.util.Map;

public class RestateRunnerBuilder {
    private static final String DEFAULT_RESTATE_CONTAINER = "docker.io/restatedev/restate";
    private final RestateHttpEndpointBuilder endpointBuilder;
    private String restateContainerImage = "docker.io/restatedev/restate";
    private final Map<String, String> additionalEnv = new HashMap<String, String>();
    private String configFile;

    RestateRunnerBuilder(RestateHttpEndpointBuilder endpointBuilder) {
        this.endpointBuilder = endpointBuilder;
    }

    public RestateRunnerBuilder withRestateContainerImage(String restateContainerImage) {
        this.restateContainerImage = restateContainerImage;
        return this;
    }

    public RestateRunnerBuilder withAdditionalEnv(String key, String value) {
        this.additionalEnv.put(key, value);
        return this;
    }

    public RestateRunnerBuilder withConfigFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    public RestateRunnerBuilder bind(Object service) {
        this.endpointBuilder.bind(service);
        return this;
    }

    public RestateRunnerBuilder bind(ServiceDefinition<?> serviceDefinition) {
        this.endpointBuilder.bind(serviceDefinition, null);
        return this;
    }

    public <O> RestateRunnerBuilder bind(ServiceDefinition<O> serviceDefinition, O options) {
        this.endpointBuilder.bind(serviceDefinition, options);
        return this;
    }

    public ManualRestateRunner buildManualRunner() {
        return new ManualRestateRunner(this.endpointBuilder.build(), this.restateContainerImage, this.additionalEnv, this.configFile);
    }

    public RestateRunner buildRunner() {
        return new RestateRunner(this.buildManualRunner());
    }

    public static RestateRunnerBuilder create() {
        return new RestateRunnerBuilder(RestateHttpEndpointBuilder.builder());
    }

    public static RestateRunnerBuilder of(RestateHttpEndpointBuilder endpointBuilder) {
        return new RestateRunnerBuilder(endpointBuilder);
    }
}

