/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.testing;

import dev.restate.admin.client.ApiClient;
import dev.restate.sdk.client.Client;
import dev.restate.sdk.testing.ManualRestateRunner;
import dev.restate.sdk.testing.RestateAdminClient;
import dev.restate.sdk.testing.RestateClient;
import dev.restate.sdk.testing.RestateURL;
import java.net.URL;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

abstract class BaseRestateRunner
implements ParameterResolver {
    static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{BaseRestateRunner.class});
    static final String DEPLOYER_KEY = "Deployer";

    BaseRestateRunner() {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(RestateAdminClient.class) && ApiClient.class.isAssignableFrom(parameterContext.getParameter().getType()) || parameterContext.isAnnotated(RestateClient.class) && Client.class.isAssignableFrom(parameterContext.getParameter().getType()) || parameterContext.isAnnotated(RestateURL.class) && (String.class.isAssignableFrom(parameterContext.getParameter().getType()) || URL.class.isAssignableFrom(parameterContext.getParameter().getType()));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (parameterContext.isAnnotated(RestateAdminClient.class)) {
            return this.getDeployer(extensionContext).getAdminClient();
        }
        if (parameterContext.isAnnotated(RestateClient.class)) {
            return this.resolveClient(extensionContext);
        }
        if (parameterContext.isAnnotated(RestateURL.class)) {
            URL url = this.getDeployer(extensionContext).getIngressUrl();
            if (parameterContext.getParameter().getType().equals(String.class)) {
                return url.toString();
            }
            return url;
        }
        throw new ParameterResolutionException("The parameter is not supported");
    }

    private Client resolveClient(ExtensionContext extensionContext) {
        URL url = this.getDeployer(extensionContext).getIngressUrl();
        return Client.connect((String)url.toString());
    }

    private ManualRestateRunner getDeployer(ExtensionContext extensionContext) {
        return (ManualRestateRunner)extensionContext.getStore(NAMESPACE).get((Object)DEPLOYER_KEY);
    }
}

