/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.testing;

import dev.restate.sdk.common.BlockingComponent;
import dev.restate.sdk.common.ComponentAdapter;
import dev.restate.sdk.common.NonBlockingComponent;
import dev.restate.sdk.http.vertx.RestateHttpEndpointBuilder;
import dev.restate.sdk.testing.ManualRestateRunner;
import dev.restate.sdk.testing.RestateRunner;
import io.grpc.ServerInterceptor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class RestateRunnerBuilder {
    private static final String DEFAULT_RESTATE_CONTAINER = "docker.io/restatedev/restate";
    private final RestateHttpEndpointBuilder endpointBuilder;
    private String restateContainerImage = "docker.io/restatedev/restate";
    private final Map<String, String> additionalEnv = new HashMap<String, String>();
    private String configFile;

    RestateRunnerBuilder(RestateHttpEndpointBuilder endpointBuilder) {
        this.endpointBuilder = endpointBuilder;
    }

    public RestateRunnerBuilder withRestateContainerImage(String restateContainerImage) {
        this.restateContainerImage = restateContainerImage;
        return this;
    }

    public RestateRunnerBuilder withAdditionalEnv(String key, String value) {
        this.additionalEnv.put(key, value);
        return this;
    }

    public RestateRunnerBuilder withConfigFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    public RestateRunnerBuilder withService(BlockingComponent service, ServerInterceptor ... interceptors) {
        this.endpointBuilder.withService(service, interceptors);
        return this;
    }

    public RestateRunnerBuilder withService(BlockingComponent service, Executor executor, ServerInterceptor ... interceptors) {
        this.endpointBuilder.withService(service, executor, interceptors);
        return this;
    }

    public RestateRunnerBuilder withService(NonBlockingComponent service, ServerInterceptor ... interceptors) {
        this.endpointBuilder.withService(service, interceptors);
        return this;
    }

    public RestateRunnerBuilder with(Object service) {
        this.endpointBuilder.with(service);
        return this;
    }

    public RestateRunnerBuilder with(Object service, Executor executor) {
        this.endpointBuilder.with(service, executor);
        return this;
    }

    public <T> RestateRunnerBuilder with(T service, ComponentAdapter<T> adapter) {
        this.endpointBuilder.with(service, adapter);
        return this;
    }

    public <T> RestateRunnerBuilder with(T service, ComponentAdapter<T> adapter, Executor executor) {
        this.endpointBuilder.with(service, adapter, executor);
        return this;
    }

    public ManualRestateRunner buildManualRunner() {
        return new ManualRestateRunner(this.endpointBuilder.build(), this.restateContainerImage, this.additionalEnv, this.configFile);
    }

    public RestateRunner buildRunner() {
        return new RestateRunner(this.buildManualRunner());
    }

    public static RestateRunnerBuilder create() {
        return new RestateRunnerBuilder(RestateHttpEndpointBuilder.builder());
    }

    public static RestateRunnerBuilder of(RestateHttpEndpointBuilder endpointBuilder) {
        return new RestateRunnerBuilder(endpointBuilder);
    }
}

