/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.testing;

import dev.restate.admin.api.DeploymentApi;
import dev.restate.admin.client.ApiClient;
import dev.restate.admin.client.ApiException;
import dev.restate.admin.model.RegisterDeploymentRequest;
import dev.restate.admin.model.RegisterDeploymentRequestAnyOf;
import dev.restate.admin.model.RegisterDeploymentResponse;
import dev.restate.admin.model.ServiceMetadata;
import io.vertx.core.http.HttpServer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.Testcontainers;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class ManualRestateRunner
implements AutoCloseable,
ExtensionContext.Store.CloseableResource {
    private static final Logger LOG = LogManager.getLogger(ManualRestateRunner.class);
    private static final String RESTATE_RUNTIME = "runtime";
    public static final int RESTATE_INGRESS_ENDPOINT_PORT = 8080;
    public static final int RESTATE_ADMIN_ENDPOINT_PORT = 9070;
    private final HttpServer server;
    private final GenericContainer<?> runtimeContainer;

    ManualRestateRunner(HttpServer server, String runtimeContainerImage, Map<String, String> additionalEnv, String configFile) {
        this.server = server;
        this.runtimeContainer = new GenericContainer(DockerImageName.parse((String)runtimeContainerImage));
        this.runtimeContainer.withExposedPorts(new Integer[]{8080, 9070}).withEnv(additionalEnv).withEnv("RESTATE_META__REST_ADDRESS", "0.0.0.0:9070").withEnv("RESTATE_WORKER__INGRESS_GRPC__BIND_ADDRESS", "0.0.0.0:8080").withNetworkAliases(new String[]{RESTATE_RUNTIME}).setWaitStrategy((WaitStrategy)new WaitAllStrategy().withStrategy((WaitStrategy)Wait.forHttp((String)"/health").forPort(9070)).withStrategy((WaitStrategy)Wait.forHttp((String)"/grpc.health.v1.Health/Check").forPort(8080)));
        if (configFile != null) {
            this.runtimeContainer.withCopyToContainer(Transferable.of((String)configFile), "/config.yaml");
            this.runtimeContainer.withEnv("RESTATE_CONFIG", "/config.yaml");
        }
    }

    public void run() {
        try {
            this.server.listen(0).toCompletionStage().toCompletableFuture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        int serviceEndpointPort = this.server.actualPort();
        LOG.debug("Started embedded service endpoint server on port {}", (Object)serviceEndpointPort);
        Testcontainers.exposeHostPorts((int[])new int[]{serviceEndpointPort});
        this.runtimeContainer.start();
        LOG.debug("Started Restate container");
        ApiClient client = this.getAdminClient();
        try {
            RegisterDeploymentResponse response = new DeploymentApi(client).createDeployment(new RegisterDeploymentRequest(new RegisterDeploymentRequestAnyOf().uri("http://host.testcontainers.internal:" + serviceEndpointPort)));
            LOG.debug("Registered services {}", response.getServices().stream().map(ServiceMetadata::getName).collect(Collectors.toList()));
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getRestateUrl() {
        try {
            return new URL("http", this.runtimeContainer.getHost(), this.runtimeContainer.getMappedPort(8080), "/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getAdminUrl() {
        try {
            return new URL("http", this.runtimeContainer.getHost(), this.runtimeContainer.getMappedPort(9070), "/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public GenericContainer<?> getRestateContainer() {
        return this.runtimeContainer;
    }

    public void stop() {
        this.close();
    }

    @Override
    public void close() {
        this.runtimeContainer.stop();
        LOG.debug("Stopped Restate container");
        this.server.close().toCompletionStage().toCompletableFuture().join();
        LOG.debug("Stopped Embedded Service endpoint server");
    }

    ApiClient getAdminClient() {
        return new ApiClient().setHost(this.runtimeContainer.getHost()).setPort(this.runtimeContainer.getMappedPort(9070).intValue());
    }

    URL getIngressUrl() {
        try {
            return new URL("http", this.runtimeContainer.getHost(), this.runtimeContainer.getMappedPort(8080), "/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

