/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.testing;

import dev.restate.admin.client.ApiClient;
import dev.restate.sdk.testing.ManualRestateRunner;
import dev.restate.sdk.testing.RestateAdminClient;
import dev.restate.sdk.testing.RestateGrpcChannel;
import dev.restate.sdk.testing.RestateURL;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

abstract class BaseRestateRunner
implements ParameterResolver {
    static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{BaseRestateRunner.class});
    private static final String MANAGED_CHANNEL_KEY = "ManagedChannelKey";
    static final String DEPLOYER_KEY = "Deployer";

    BaseRestateRunner() {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(RestateAdminClient.class) && ApiClient.class.isAssignableFrom(parameterContext.getParameter().getType()) || parameterContext.isAnnotated(RestateGrpcChannel.class) && ManagedChannel.class.isAssignableFrom(parameterContext.getParameter().getType()) || parameterContext.isAnnotated(RestateURL.class) && (String.class.isAssignableFrom(parameterContext.getParameter().getType()) || URL.class.isAssignableFrom(parameterContext.getParameter().getType()));
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (parameterContext.isAnnotated(RestateAdminClient.class)) {
            return this.getDeployer(extensionContext).getAdminClient();
        }
        if (parameterContext.isAnnotated(RestateGrpcChannel.class)) {
            return this.resolveChannel(extensionContext);
        }
        if (parameterContext.isAnnotated(RestateURL.class)) {
            URL url = this.getDeployer(extensionContext).getIngressUrl();
            if (parameterContext.getParameter().getType().equals(String.class)) {
                return url.toString();
            }
            return url;
        }
        throw new ParameterResolutionException("The parameter is not supported");
    }

    private ManagedChannel resolveChannel(ExtensionContext extensionContext) {
        return ((ManagedChannelResource)extensionContext.getStore((ExtensionContext.Namespace)BaseRestateRunner.NAMESPACE).getOrComputeIfAbsent((Object)MANAGED_CHANNEL_KEY, (Function<String, ManagedChannelResource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$resolveChannel$0(org.junit.jupiter.api.extension.ExtensionContext java.lang.String ), (Ljava/lang/String;)Ldev/restate/sdk/testing/BaseRestateRunner$ManagedChannelResource;)((BaseRestateRunner)this, (ExtensionContext)extensionContext), ManagedChannelResource.class)).channel;
    }

    private ManualRestateRunner getDeployer(ExtensionContext extensionContext) {
        return (ManualRestateRunner)extensionContext.getStore(NAMESPACE).get((Object)DEPLOYER_KEY);
    }

    private /* synthetic */ ManagedChannelResource lambda$resolveChannel$0(ExtensionContext extensionContext, String k) {
        URL url = this.getDeployer(extensionContext).getIngressUrl();
        ManagedChannel channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)url.getHost(), (int)url.getPort()).disableServiceConfigLookUp()).usePlaintext().build();
        return new ManagedChannelResource(channel);
    }

    private static class ManagedChannelResource
    implements ExtensionContext.Store.CloseableResource {
        private final ManagedChannel channel;

        private ManagedChannelResource(ManagedChannel channel) {
            this.channel = channel;
        }

        public void close() throws Exception {
            this.channel.shutdown();
            if (this.channel.awaitTermination(5L, TimeUnit.SECONDS)) {
                return;
            }
            this.channel.shutdownNow();
            if (!this.channel.awaitTermination(5L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Cannot terminate ManagedChannel on time");
            }
        }
    }
}

