/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.serde.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UnsafeByteOperations;
import dev.restate.sdk.common.Serde;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public abstract class ProtobufSerdes {
    private ProtobufSerdes() {
    }

    public static <T extends MessageLite> Serde<T> of(final Parser<T> parser) {
        return new Serde<T>(){

            public byte[] serialize(@Nullable T value) {
                return ((MessageLite)Objects.requireNonNull(value)).toByteArray();
            }

            public T deserialize(byte[] value) {
                try {
                    return (MessageLite)parser.parseFrom(value);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Cannot deserialize Protobuf object", e);
                }
            }

            public ByteBuffer serializeToByteBuffer(@Nullable T value) {
                return ((MessageLite)Objects.requireNonNull(value)).toByteString().asReadOnlyByteBuffer();
            }

            public T deserialize(ByteBuffer byteBuffer) {
                try {
                    return (MessageLite)parser.parseFrom(UnsafeByteOperations.unsafeWrap((ByteBuffer)byteBuffer.rewind()));
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Cannot deserialize Protobuf object", e);
                }
            }
        };
    }
}

