/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.serde.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import dev.restate.sdk.common.Serde;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public abstract class ProtobufSerdes {
    private ProtobufSerdes() {
    }

    public static <T extends MessageLite> Serde<T> of(final Parser<T> parser) {
        return new Serde<T>(){

            public byte[] serialize(@Nullable T value) {
                return ((MessageLite)Objects.requireNonNull(value)).toByteArray();
            }

            public T deserialize(byte[] value) {
                try {
                    return (MessageLite)parser.parseFrom(value);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Cannot deserialize Protobuf object", e);
                }
            }

            public ByteString serializeToByteString(@Nullable T value) {
                return ((MessageLite)Objects.requireNonNull(value)).toByteString();
            }

            public T deserialize(ByteString byteString) {
                try {
                    return (MessageLite)parser.parseFrom(byteString);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException("Cannot deserialize Protobuf object", e);
                }
            }
        };
    }
}

