/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.auth.signing;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.Ed25519Verifier;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.SignedJWT;
import dev.restate.sdk.auth.RequestIdentityVerifier;
import dev.restate.sdk.auth.signing.Base58;

public class RestateRequestIdentityVerifier
implements RequestIdentityVerifier {
    private static final String SIGNATURE_SCHEME_HEADER = "x-restate-signature-scheme";
    private static final String SIGNATURE_SCHEME_V1 = "v1";
    private static final String SIGNATURE_SCHEME_UNSIGNED = "unsigned";
    private static final String JWT_HEADER = "x-restate-jwt-v1";
    private static final String IDENTITY_V1_PREFIX = "publickeyv1_";
    private final JWSVerifier verifier;

    private RestateRequestIdentityVerifier(JWSVerifier verifier) {
        this.verifier = verifier;
    }

    public void verifyRequest(RequestIdentityVerifier.Headers headers) throws Exception {
        String signatureScheme;
        switch (signatureScheme = this.expectHeader(headers, SIGNATURE_SCHEME_HEADER)) {
            case "v1": {
                String jwtHeader = this.expectHeader(headers, JWT_HEADER);
                SignedJWT signedJWT = SignedJWT.parse((String)jwtHeader);
                if (signedJWT.verify(this.verifier)) break;
                throw new IllegalStateException("Verification of JWT token failed");
            }
            case "unsigned": {
                throw new IllegalStateException("Request has no identity, but one was expected");
            }
            default: {
                throw new IllegalStateException("Unexpected signature scheme " + signatureScheme);
            }
        }
    }

    private String expectHeader(RequestIdentityVerifier.Headers headers, String key) {
        String value = headers.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Missing header " + key);
        }
        return value;
    }

    public static RequestIdentityVerifier fromKey(String key) {
        Ed25519Verifier verifier;
        if (!key.startsWith(IDENTITY_V1_PREFIX)) {
            throw new IllegalArgumentException("Identity v1 jwt public keys are expected to start with publickeyv1_");
        }
        byte[] decoded = Base58.decode(key.substring(IDENTITY_V1_PREFIX.length()));
        if (decoded.length != 32) {
            throw new IllegalArgumentException("Decoded key should have length of 32, was " + decoded.length);
        }
        OctetKeyPair jwk = new OctetKeyPair.Builder(Curve.Ed25519, Base64URL.encode((byte[])decoded)).build();
        OctetKeyPair publicJWK = jwk.toPublicJWK();
        try {
            verifier = new Ed25519Verifier(publicJWK);
        }
        catch (JOSEException e) {
            throw new RuntimeException("Cannot create the verifier", e);
        }
        return new RestateRequestIdentityVerifier((JWSVerifier)verifier);
    }
}

