/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.lambda;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import dev.restate.sdk.core.ProtocolException;
import dev.restate.sdk.core.ResolvedEndpointHandler;
import dev.restate.sdk.core.RestateEndpoint;
import dev.restate.sdk.lambda.LambdaFlowAdapters;
import dev.restate.sdk.lambda.RestateLambdaEndpointBuilder;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public final class RestateLambdaEndpoint {
    private static final Logger LOG = LogManager.getLogger(RestateLambdaEndpoint.class);
    private static final Pattern SLASH = Pattern.compile(Pattern.quote("/"));
    private static final String INVOKE_PATH_SEGMENT = "invoke";
    private static final String DISCOVER_PATH = "/discover";
    private static TextMapGetter<Map<String, String>> OTEL_HEADERS_GETTER = new TextMapGetter<Map<String, String>>(){

        public Iterable<String> keys(Map<String, String> carrier) {
            return carrier.keySet();
        }

        public String get(Map<String, String> carrier, String key) {
            if (carrier == null) {
                return null;
            }
            return carrier.get(key);
        }
    };
    private final RestateEndpoint restateEndpoint;
    private final OpenTelemetry openTelemetry;

    RestateLambdaEndpoint(RestateEndpoint restateEndpoint, OpenTelemetry openTelemetry) {
        this.restateEndpoint = restateEndpoint;
        this.openTelemetry = openTelemetry;
    }

    public static RestateLambdaEndpointBuilder builder() {
        return new RestateLambdaEndpointBuilder();
    }

    public APIGatewayProxyResponseEvent handleRequest(APIGatewayProxyRequestEvent input, com.amazonaws.services.lambda.runtime.Context context) {
        String path = input.getPath().endsWith("/") ? input.getPath().substring(0, input.getPath().length() - 1) : input.getPath();
        try {
            if (path.endsWith(DISCOVER_PATH)) {
                return this.handleDiscovery((String)input.getHeaders().get("accept"));
            }
            return this.handleInvoke(input);
        }
        catch (ProtocolException e) {
            LOG.warn("Error when handling the request", (Throwable)e);
            return new APIGatewayProxyResponseEvent().withStatusCode(Integer.valueOf(e.getCode())).withHeaders(Map.of("content-type", "text/plain", "x-restate-server", "restate-sdk-java/1.0.0_fd335fb0")).withBody(e.getMessage());
        }
    }

    private APIGatewayProxyResponseEvent handleInvoke(APIGatewayProxyRequestEvent input) {
        byte[] responseBody;
        ResolvedEndpointHandler handler;
        String[] pathSegments = SLASH.split(input.getPath());
        if (pathSegments.length < 3 || !INVOKE_PATH_SEGMENT.equalsIgnoreCase(pathSegments[pathSegments.length - 3])) {
            LOG.warn("Path doesn't match the pattern /invoke/SvcName/MethodName: '{}'", (Object)input.getPath());
            return new APIGatewayProxyResponseEvent().withStatusCode(Integer.valueOf(404));
        }
        String serviceName = pathSegments[pathSegments.length - 2];
        String handlerName = pathSegments[pathSegments.length - 1];
        Context otelContext = this.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)input.getHeaders(), OTEL_HEADERS_GETTER);
        ByteBuffer requestBody = RestateLambdaEndpoint.parseInputBody(input);
        try {
            handler = this.restateEndpoint.resolve((String)input.getHeaders().get("content-type"), serviceName, handlerName, input.getHeaders()::get, otelContext, RestateEndpoint.LoggingContextSetter.THREAD_LOCAL_INSTANCE, null);
        }
        catch (ProtocolException e) {
            LOG.warn("Error when resolving the grpc handler", (Throwable)e);
            return new APIGatewayProxyResponseEvent().withStatusCode(Integer.valueOf(e.getCode()));
        }
        LambdaFlowAdapters.BufferedPublisher publisher = new LambdaFlowAdapters.BufferedPublisher(requestBody);
        LambdaFlowAdapters.ResultSubscriber subscriber = new LambdaFlowAdapters.ResultSubscriber();
        publisher.subscribe((Flow.Subscriber<? super ByteBuffer>)handler);
        handler.subscribe((Flow.Subscriber)((Object)subscriber));
        try {
            responseBody = subscriber.getResult();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        ThreadContext.clearAll();
        APIGatewayProxyResponseEvent response = new APIGatewayProxyResponseEvent();
        response.setHeaders(Map.of("content-type", handler.responseContentType(), "x-restate-server", "restate-sdk-java/1.0.0_fd335fb0"));
        response.setIsBase64Encoded(Boolean.valueOf(true));
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(Base64.getEncoder().encodeToString(responseBody));
        return response;
    }

    private APIGatewayProxyResponseEvent handleDiscovery(String acceptVersionsString) {
        RestateEndpoint.DiscoveryResponse discoveryResponse = this.restateEndpoint.handleDiscoveryRequest(acceptVersionsString);
        APIGatewayProxyResponseEvent response = new APIGatewayProxyResponseEvent();
        response.setHeaders(Map.of("content-type", discoveryResponse.getContentType(), "x-restate-server", "restate-sdk-java/1.0.0_fd335fb0"));
        response.setIsBase64Encoded(Boolean.valueOf(true));
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(Base64.getEncoder().encodeToString(discoveryResponse.getSerializedManifest()));
        return response;
    }

    private static ByteBuffer parseInputBody(APIGatewayProxyRequestEvent input) {
        if (input.getBody() == null) {
            return ByteBuffer.wrap(new byte[0]);
        }
        if (!input.getIsBase64Encoded().booleanValue()) {
            throw new IllegalArgumentException("Input is not Base64 encoded. This is most likely an SDK bug, please contact the developers.");
        }
        return ByteBuffer.wrap(Base64.getDecoder().decode(input.getBody()));
    }
}

