/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.lambda;

import dev.restate.sdk.core.InvocationFlow;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;

class LambdaFlowAdapters {
    LambdaFlowAdapters() {
    }

    static class BufferedPublisher
    implements InvocationFlow.InvocationInputPublisher {
        private ByteBuffer buffer;

        BufferedPublisher(ByteBuffer buffer) {
            this.buffer = buffer.asReadOnlyBuffer();
        }

        public void subscribe(final Flow.Subscriber<? super ByteBuffer> subscriber) {
            subscriber.onSubscribe(new Flow.Subscription(){

                @Override
                public void request(long l) {
                    if (buffer != null) {
                        subscriber.onNext(buffer);
                        subscriber.onComplete();
                        buffer = null;
                    }
                }

                @Override
                public void cancel() {
                }
            });
        }
    }

    static class ResultSubscriber
    implements InvocationFlow.InvocationOutputSubscriber {
        private final CompletableFuture<Void> completionFuture = new CompletableFuture();
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        private final WritableByteChannel channel = Channels.newChannel(this.outputStream);

        ResultSubscriber() {
        }

        public void onSubscribe(Flow.Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(ByteBuffer item) {
            try {
                this.channel.write(item);
            }
            catch (IOException e) {
                this.completionFuture.completeExceptionally(e);
            }
        }

        public void onError(Throwable throwable) {
            this.completionFuture.completeExceptionally(throwable);
        }

        public void onComplete() {
            this.completionFuture.complete(null);
        }

        public byte[] getResult() throws Throwable {
            try {
                this.completionFuture.get();
                return this.outputStream.toByteArray();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }
}

