/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import dev.restate.sdk.lambda.RestateLambdaEndpoint;
import dev.restate.sdk.lambda.RestateLambdaEndpointBuilder;
import org.apache.logging.log4j.CloseableThreadContext;

public abstract class BaseRestateLambdaHandler
implements RequestHandler<APIGatewayProxyRequestEvent, APIGatewayProxyResponseEvent> {
    private static final String AWS_REQUEST_ID = "AWSRequestId";
    private final RestateLambdaEndpoint restateLambdaEndpoint;

    protected BaseRestateLambdaHandler() {
        RestateLambdaEndpointBuilder builder = RestateLambdaEndpoint.builder();
        this.register(builder);
        this.restateLambdaEndpoint = builder.build();
    }

    public abstract void register(RestateLambdaEndpointBuilder var1);

    public APIGatewayProxyResponseEvent handleRequest(APIGatewayProxyRequestEvent input, Context context) {
        try (CloseableThreadContext.Instance requestId = CloseableThreadContext.put((String)AWS_REQUEST_ID, (String)context.getAwsRequestId());){
            APIGatewayProxyResponseEvent aPIGatewayProxyResponseEvent = this.restateLambdaEndpoint.handleRequest(input, context);
            return aPIGatewayProxyResponseEvent;
        }
    }
}

