/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.lambda;

import dev.restate.sdk.auth.RequestIdentityVerifier;
import dev.restate.sdk.common.BindableService;
import dev.restate.sdk.common.syscalls.ServiceDefinition;
import dev.restate.sdk.core.RestateEndpoint;
import dev.restate.sdk.core.manifest.DeploymentManifestSchema;
import dev.restate.sdk.lambda.RestateLambdaEndpoint;
import io.opentelemetry.api.OpenTelemetry;

public final class RestateLambdaEndpointBuilder {
    private final RestateEndpoint.Builder restateEndpoint = RestateEndpoint.newBuilder((DeploymentManifestSchema.ProtocolMode)DeploymentManifestSchema.ProtocolMode.REQUEST_RESPONSE);
    private OpenTelemetry openTelemetry = OpenTelemetry.noop();

    public RestateLambdaEndpointBuilder bind(Object service) {
        return this.bind(RestateEndpoint.discoverBindableServiceFactory((Object)service).create(service));
    }

    public RestateLambdaEndpointBuilder bind(BindableService<?> service) {
        for (ServiceDefinition serviceDefinition : service.definitions()) {
            this.restateEndpoint.bind(serviceDefinition, service.options());
        }
        return this;
    }

    public RestateLambdaEndpointBuilder withOpenTelemetry(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
        return this;
    }

    public RestateLambdaEndpointBuilder withRequestIdentityVerifier(RequestIdentityVerifier requestIdentityVerifier) {
        this.restateEndpoint.withRequestIdentityVerifier(requestIdentityVerifier);
        return this;
    }

    public RestateLambdaEndpoint build() {
        return new RestateLambdaEndpoint(this.restateEndpoint.build(), this.openTelemetry);
    }
}

