/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.lambda;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import dev.restate.sdk.core.InvocationFlow;
import dev.restate.sdk.core.MessageHeader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class LambdaFlowAdapters {
    LambdaFlowAdapters() {
    }

    static class BufferedPublisher
    implements InvocationFlow.InvocationInputPublisher {
        private static final Logger LOG = LogManager.getLogger(BufferedPublisher.class);
        private final ByteBuffer buffer;
        private Flow.Subscriber<? super InvocationFlow.InvocationInput> inputMessagesSubscriber;
        private long subscriberRequest = 0L;

        BufferedPublisher(ByteBuffer buffer) {
            this.buffer = buffer.asReadOnlyBuffer();
        }

        public void subscribe(Flow.Subscriber<? super InvocationFlow.InvocationInput> subscriber) {
            if (this.inputMessagesSubscriber != null) {
                throw new IllegalStateException("Cannot register more than one subscriber to this publisher");
            }
            this.buffer.rewind();
            this.inputMessagesSubscriber = subscriber;
            this.inputMessagesSubscriber.onSubscribe(new Flow.Subscription(){

                @Override
                public void request(long l) {
                    this.handleSubscriptionRequest(l);
                }

                @Override
                public void cancel() {
                    this.cancelSubscription();
                }
            });
        }

        private void handleSubscriptionRequest(long l) {
            if (l == Long.MAX_VALUE) {
                this.subscriberRequest = l;
            } else {
                this.subscriberRequest += l;
                if (this.subscriberRequest < 0L) {
                    this.subscriberRequest = Long.MAX_VALUE;
                }
            }
            while (this.subscriberRequest > 0L && this.inputMessagesSubscriber != null) {
                MessageLite entry;
                MessageHeader header;
                if (!this.buffer.hasRemaining()) {
                    this.handleBufferEnd();
                    return;
                }
                try {
                    header = MessageHeader.parse((long)this.buffer.getLong());
                    ByteBuffer messageBuffer = this.buffer.slice();
                    messageBuffer.limit(header.getLength());
                    entry = (MessageLite)header.getType().messageParser().parseFrom(messageBuffer);
                    this.buffer.position(this.buffer.position() + header.getLength());
                }
                catch (InvalidProtocolBufferException | RuntimeException e) {
                    this.handleDecodingError(e);
                    return;
                }
                LOG.trace("Received entry " + entry);
                --this.subscriberRequest;
                this.inputMessagesSubscriber.onNext((InvocationFlow.InvocationInput)InvocationFlow.InvocationInput.of((MessageHeader)header, (MessageLite)entry));
            }
        }

        private void handleDecodingError(Throwable e) {
            this.inputMessagesSubscriber.onError(e);
            this.cancelSubscription();
        }

        private void handleBufferEnd() {
            LOG.trace("Request end");
            this.inputMessagesSubscriber.onComplete();
            this.cancelSubscription();
        }

        private void cancelSubscription() {
            this.inputMessagesSubscriber = null;
        }
    }

    static class ResultSubscriber
    implements InvocationFlow.InvocationOutputSubscriber {
        private static final ByteBuffer LONG_CONVERSION_BUFFER = ByteBuffer.allocate(8);
        private final ByteArrayOutputStream outputStream;
        private final CompletableFuture<Void> completionFuture = new CompletableFuture();

        ResultSubscriber() {
            this.outputStream = new ByteArrayOutputStream();
        }

        public void onSubscribe(Flow.Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(MessageLite item) {
            LONG_CONVERSION_BUFFER.putLong(0, MessageHeader.fromMessage((MessageLite)item).encode());
            try {
                this.outputStream.write(LONG_CONVERSION_BUFFER.array());
                item.writeTo((OutputStream)this.outputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void onError(Throwable throwable) {
            this.completionFuture.completeExceptionally(throwable);
        }

        public void onComplete() {
            this.completionFuture.complete(null);
        }

        public byte[] getResult() throws Throwable {
            try {
                this.completionFuture.get();
                return this.outputStream.toByteArray();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }
}

