/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.lambda;

import dev.restate.generated.service.discovery.Discovery;
import dev.restate.sdk.common.Component;
import dev.restate.sdk.common.ComponentAdapter;
import dev.restate.sdk.core.RestateEndpoint;
import dev.restate.sdk.lambda.RestateLambdaEndpoint;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.opentelemetry.api.OpenTelemetry;
import java.util.Arrays;
import java.util.List;

public final class RestateLambdaEndpointBuilder {
    private final RestateEndpoint.Builder restateGrpcServerBuilder = RestateEndpoint.newBuilder((Discovery.ProtocolMode)Discovery.ProtocolMode.REQUEST_RESPONSE);
    private OpenTelemetry openTelemetry = OpenTelemetry.noop();

    public RestateLambdaEndpointBuilder withService(Component component, ServerInterceptor ... interceptors) {
        ServerServiceDefinition definition = ServerInterceptors.intercept((BindableService)component, Arrays.asList(interceptors));
        this.restateGrpcServerBuilder.withService(definition);
        return this;
    }

    public RestateLambdaEndpointBuilder with(Object service) {
        return this.with(service, RestateEndpoint.discoverAdapter((Object)service));
    }

    public <T> RestateLambdaEndpointBuilder with(T service, ComponentAdapter<T> adapter) {
        List services = adapter.adapt(service).components();
        for (Component svc : services) {
            this.restateGrpcServerBuilder.withService((BindableService)svc);
        }
        return this;
    }

    public RestateLambdaEndpointBuilder withOpenTelemetry(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
        return this;
    }

    public RestateLambdaEndpoint build() {
        return new RestateLambdaEndpoint(this.restateGrpcServerBuilder.build(), this.openTelemetry);
    }
}

