/*
 * Decompiled with CFR 0.152.
 */
package dev.restate.sdk.lambda;

import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.google.protobuf.InvalidProtocolBufferException;
import dev.restate.generated.service.discovery.Discovery;
import dev.restate.sdk.core.InvocationFlow;
import dev.restate.sdk.core.InvocationHandler;
import dev.restate.sdk.core.ProtocolException;
import dev.restate.sdk.core.RestateEndpoint;
import dev.restate.sdk.lambda.LambdaFlowAdapters;
import dev.restate.sdk.lambda.RestateLambdaEndpointBuilder;
import io.grpc.Status;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public final class RestateLambdaEndpoint {
    private static final Logger LOG = LogManager.getLogger(RestateLambdaEndpoint.class);
    private static final Pattern SLASH = Pattern.compile(Pattern.quote("/"));
    private static final String INVOKE_PATH_SEGMENT = "invoke";
    private static final String DISCOVER_PATH = "/discover";
    private static final Map<String, String> INVOKE_RESPONSE_HEADERS = Map.of("content-type", "application/restate");
    private static final Map<String, String> DISCOVER_RESPONSE_HEADERS = Map.of("content-type", "application/proto");
    private static TextMapGetter<Map<String, String>> OTEL_HEADERS_GETTER = new TextMapGetter<Map<String, String>>(){

        public Iterable<String> keys(Map<String, String> carrier) {
            return carrier.keySet();
        }

        @Nullable
        public String get(@Nullable Map<String, String> carrier, String key) {
            if (carrier == null) {
                return null;
            }
            return carrier.get(key);
        }
    };
    private final RestateEndpoint restateEndpoint;
    private final OpenTelemetry openTelemetry;

    RestateLambdaEndpoint(RestateEndpoint restateEndpoint, OpenTelemetry openTelemetry) {
        this.restateEndpoint = restateEndpoint;
        this.openTelemetry = openTelemetry;
    }

    public static RestateLambdaEndpointBuilder builder() {
        return new RestateLambdaEndpointBuilder();
    }

    public APIGatewayProxyResponseEvent handleRequest(APIGatewayProxyRequestEvent input, com.amazonaws.services.lambda.runtime.Context context) {
        String path;
        String string = path = input.getPath().endsWith("/") ? input.getPath().substring(0, input.getPath().length() - 1) : input.getPath();
        if (path.endsWith(DISCOVER_PATH)) {
            return this.handleDiscovery(input);
        }
        return this.handleInvoke(input);
    }

    private APIGatewayProxyResponseEvent handleInvoke(APIGatewayProxyRequestEvent input) {
        InvocationHandler handler;
        String[] pathSegments = SLASH.split(input.getPath());
        if (pathSegments.length < 3 || !INVOKE_PATH_SEGMENT.equalsIgnoreCase(pathSegments[pathSegments.length - 3])) {
            LOG.warn("Path doesn't match the pattern /invoke/SvcName/MethodName: '{}'", (Object)input.getPath());
            return new APIGatewayProxyResponseEvent().withStatusCode(Integer.valueOf(404));
        }
        String service = pathSegments[pathSegments.length - 2];
        String method = pathSegments[pathSegments.length - 1];
        Context otelContext = this.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)input.getHeaders(), OTEL_HEADERS_GETTER);
        ByteBuffer requestBody = RestateLambdaEndpoint.parseInputBody(input);
        try {
            handler = this.restateEndpoint.resolve(service, method, otelContext, RestateEndpoint.LoggingContextSetter.THREAD_LOCAL_INSTANCE, null, null);
        }
        catch (ProtocolException e) {
            LOG.warn("Error when resolving the grpc handler", (Throwable)e);
            return new APIGatewayProxyResponseEvent().withStatusCode(Integer.valueOf(e.getFailureCode() == Status.Code.NOT_FOUND.value() ? 404 : 500));
        }
        LambdaFlowAdapters.BufferedPublisher publisher = new LambdaFlowAdapters.BufferedPublisher(requestBody);
        LambdaFlowAdapters.ResultSubscriber subscriber = new LambdaFlowAdapters.ResultSubscriber();
        publisher.subscribe((Flow.Subscriber<? super InvocationFlow.InvocationInput>)handler.input());
        handler.output().subscribe((Flow.Subscriber)((Object)subscriber));
        handler.start();
        byte[] responseBody = subscriber.getResult();
        ThreadContext.clearAll();
        APIGatewayProxyResponseEvent response = new APIGatewayProxyResponseEvent();
        response.setHeaders(INVOKE_RESPONSE_HEADERS);
        response.setIsBase64Encoded(Boolean.valueOf(true));
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(Base64.getEncoder().encodeToString(responseBody));
        return response;
    }

    private APIGatewayProxyResponseEvent handleDiscovery(APIGatewayProxyRequestEvent input) {
        Discovery.ServiceDiscoveryRequest discoveryRequest;
        ByteBuffer requestBody = RestateLambdaEndpoint.parseInputBody(input);
        try {
            discoveryRequest = Discovery.ServiceDiscoveryRequest.parseFrom((ByteBuffer)requestBody);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Cannot decode discovery request", e);
        }
        Discovery.ServiceDiscoveryResponse discoveryResponse = this.restateEndpoint.handleDiscoveryRequest(discoveryRequest);
        APIGatewayProxyResponseEvent response = new APIGatewayProxyResponseEvent();
        response.setHeaders(DISCOVER_RESPONSE_HEADERS);
        response.setIsBase64Encoded(Boolean.valueOf(true));
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(Base64.getEncoder().encodeToString(discoveryResponse.toByteArray()));
        return response;
    }

    private static ByteBuffer parseInputBody(APIGatewayProxyRequestEvent input) {
        if (input.getBody() == null) {
            return ByteBuffer.wrap(new byte[0]);
        }
        if (!input.getIsBase64Encoded().booleanValue()) {
            throw new IllegalArgumentException("Input is not Base64 encoded. This is most likely an SDK bug, please contact the developers.");
        }
        return ByteBuffer.wrap(Base64.getDecoder().decode(input.getBody()));
    }
}

